/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server.netty.metrics;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.dna.mqtt.moquette.server.netty.metrics.BytesMetrics;
import org.dna.mqtt.moquette.server.netty.metrics.BytesMetricsCollector;

public class BytesMetricsHandler
extends ChannelDuplexHandler {
    private static final AttributeKey<BytesMetrics> ATTR_KEY_METRICS = new AttributeKey("BytesMetrics");
    private BytesMetricsCollector m_collector;

    public BytesMetricsHandler(BytesMetricsCollector collector) {
        this.m_collector = collector;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Attribute attr = ctx.attr(ATTR_KEY_METRICS);
        attr.set((Object)new BytesMetrics());
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        BytesMetrics metrics = (BytesMetrics)ctx.attr(ATTR_KEY_METRICS).get();
        metrics.incrementRead(((ByteBuf)msg).readableBytes());
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        BytesMetrics metrics = (BytesMetrics)ctx.attr(ATTR_KEY_METRICS).get();
        metrics.incrementWrote(((ByteBuf)msg).writableBytes());
        ctx.write(msg, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        BytesMetrics metrics = (BytesMetrics)ctx.attr(ATTR_KEY_METRICS).get();
        this.m_collector.addMetrics(metrics);
        super.close(ctx, promise);
    }
}

