/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.messaging.spi.IMessaging;
import org.dna.mqtt.moquette.proto.Utils;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.proto.messages.PingRespMessage;
import org.dna.mqtt.moquette.server.netty.NettyChannel;
import org.dna.mqtt.wso2.MQTTPingRequest;

@ChannelHandler.Sharable
public class NettyMQTTHandler
extends ChannelInboundHandlerAdapter {
    private static Log log = LogFactory.getLog(NettyMQTTHandler.class);
    private IMessaging m_messaging;
    private final Map<ChannelHandlerContext, NettyChannel> mqttChannelMapper = new HashMap<ChannelHandlerContext, NettyChannel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        AbstractMessage msg = (AbstractMessage)message;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a message of type " + Utils.msgType2String(msg.getMessageType())));
        }
        try {
            switch (msg.getMessageType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 14: {
                    NettyChannel channel = null;
                    Map<ChannelHandlerContext, NettyChannel> map = this.mqttChannelMapper;
                    synchronized (map) {
                        if (!this.mqttChannelMapper.containsKey(ctx)) {
                            this.mqttChannelMapper.put(ctx, new NettyChannel(ctx));
                        }
                        channel = this.mqttChannelMapper.get(ctx);
                    }
                    this.m_messaging.handleProtocolMessage(channel, msg);
                    break;
                }
                case 12: {
                    NettyChannel channel;
                    PingRespMessage pingResp = new PingRespMessage();
                    ctx.writeAndFlush((Object)pingResp);
                    Map<ChannelHandlerContext, NettyChannel> map = this.mqttChannelMapper;
                    synchronized (map) {
                        channel = this.mqttChannelMapper.get(ctx);
                        if (null == channel) {
                            this.mqttChannelMapper.put(ctx, new NettyChannel(ctx));
                        }
                    }
                    MQTTPingRequest mqttPingRequest = new MQTTPingRequest();
                    mqttPingRequest.setChannelId(channel.getAttribute("ClientID").toString());
                    this.m_messaging.handleProtocolMessage(channel, mqttPingRequest);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Bad error in processing the message", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        NettyChannel channel = this.mqttChannelMapper.get(ctx);
        if (null != channel) {
            String clientID = (String)channel.getAttribute("ClientID");
            this.m_messaging.lostConnection(clientID);
            ctx.close();
        }
        Map<ChannelHandlerContext, NettyChannel> map = this.mqttChannelMapper;
        synchronized (map) {
            this.mqttChannelMapper.remove(ctx);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error((Object)cause.getMessage(), cause);
        ctx.close();
    }

    public void setMessaging(IMessaging messaging) {
        this.m_messaging = messaging;
    }
}

