/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.dna.mqtt.moquette.server.ServerChannel;
import org.dna.mqtt.moquette.server.netty.MoquetteIdleTimoutHandler;

public class NettyChannel
implements ServerChannel {
    private ChannelHandlerContext m_channel;
    private Map<Object, AttributeKey<Object>> m_attributesKeys = new HashMap<Object, AttributeKey<Object>>();
    public static final String ATTR_USERNAME = "username";
    private static final AttributeKey<Object> ATTR_KEY_KEEPALIVE = new AttributeKey("keepAlive");
    private static final AttributeKey<Object> ATTR_KEY_CLEANSESSION = new AttributeKey("cleanSession");
    private static final AttributeKey<Object> ATTR_KEY_CLIENTID = new AttributeKey("ClientID");
    public static final AttributeKey<Object> ATTR_KEY_USERNAME = AttributeKey.valueOf((String)"username");
    private final UUID uuid = UUID.randomUUID();

    NettyChannel(ChannelHandlerContext ctx) {
        this.m_channel = ctx;
        this.m_attributesKeys.put("keepAlive", ATTR_KEY_KEEPALIVE);
        this.m_attributesKeys.put("cleanSession", ATTR_KEY_CLEANSESSION);
        this.m_attributesKeys.put("ClientID", ATTR_KEY_CLIENTID);
        this.m_attributesKeys.put(ATTR_USERNAME, ATTR_KEY_USERNAME);
    }

    @Override
    public Object getAttribute(Object key) {
        Attribute attr = this.m_channel.attr(this.mapKey(key));
        return attr.get();
    }

    @Override
    public void setAttribute(Object key, Object value) {
        Attribute attr = this.m_channel.attr(this.mapKey(key.toString()));
        attr.set(value);
    }

    private synchronized AttributeKey<Object> mapKey(Object key) {
        if (!this.m_attributesKeys.containsKey(key)) {
            throw new IllegalArgumentException("mapKey can't find a matching AttributeKey for " + key);
        }
        return this.m_attributesKeys.get(key);
    }

    @Override
    public void setIdleTime(int idleTime) {
        if (this.m_channel.pipeline().names().contains("idleStateHandler")) {
            this.m_channel.pipeline().remove("idleStateHandler");
        }
        if (this.m_channel.pipeline().names().contains("idleEventHandler")) {
            this.m_channel.pipeline().remove("idleEventHandler");
        }
        this.m_channel.pipeline().addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, idleTime));
        this.m_channel.pipeline().addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)new MoquetteIdleTimoutHandler());
    }

    @Override
    public Channel getSocketChannel() {
        return this.m_channel.channel();
    }

    @Override
    public void close(boolean immediately) {
        this.m_channel.close();
    }

    @Override
    public void write(Object value) {
        this.m_channel.writeAndFlush(value);
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }
}

