/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.dna.mqtt.moquette.messaging.spi.IMessaging;
import org.dna.mqtt.moquette.parser.netty.MQTTDecoder;
import org.dna.mqtt.moquette.parser.netty.MQTTEncoder;
import org.dna.mqtt.moquette.server.ServerAcceptor;
import org.dna.mqtt.moquette.server.netty.MoquetteIdleTimoutHandler;
import org.dna.mqtt.moquette.server.netty.NettyMQTTHandler;
import org.dna.mqtt.moquette.server.netty.metrics.BytesMetrics;
import org.dna.mqtt.moquette.server.netty.metrics.BytesMetricsCollector;
import org.dna.mqtt.moquette.server.netty.metrics.BytesMetricsHandler;
import org.dna.mqtt.moquette.server.netty.metrics.MessageMetrics;
import org.dna.mqtt.moquette.server.netty.metrics.MessageMetricsCollector;
import org.dna.mqtt.moquette.server.netty.metrics.MessageMetricsHandler;
import org.dna.mqtt.moquette.server.netty.metrics.SSLHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAcceptor
implements ServerAcceptor {
    private static final Logger log = LoggerFactory.getLogger(NettyAcceptor.class);
    EventLoopGroup m_bossGroup;
    EventLoopGroup m_workerGroup;
    BytesMetricsCollector m_bytesMetricsCollector = new BytesMetricsCollector();
    MessageMetricsCollector m_metricsCollector = new MessageMetricsCollector();

    @Override
    public void initialize(IMessaging messaging, Properties props) throws IOException {
        this.m_bossGroup = new NioEventLoopGroup();
        this.m_workerGroup = new NioEventLoopGroup();
        String sslTcpPortProp = props.get("sslPort").toString();
        String wssPortProp = props.getProperty("secure_websocket_port");
        Boolean sslPortEnabled = Boolean.parseBoolean(props.get("sslEnabled").toString());
        Boolean defaultPortEnabled = Boolean.parseBoolean(props.get("portEnabled").toString());
        if (defaultPortEnabled.booleanValue()) {
            this.initializePlainTCPTransport(messaging, props);
        } else {
            log.warn("MQTT port has disabled as per configuration.");
        }
        if (sslTcpPortProp != null && sslPortEnabled.booleanValue()) {
            SSLHandlerFactory sslHandlerFactory = this.initSSLHandlerFactory(props);
            if (!sslHandlerFactory.canCreate()) {
                log.error("Can't initialize SSLHandler layer! Exiting, check your configuration of jks");
                return;
            }
            this.initializeSSLTCPTransport(messaging, props, sslHandlerFactory);
        } else {
            log.warn("MQTT SSL port not readable or has been disabled as per configuration.");
        }
    }

    private void initFactory(String host, int port, final PipelineInitializer pipeliner) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.m_bossGroup, this.m_workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                try {
                    pipeliner.init(pipeline);
                }
                catch (Throwable th) {
                    log.error("Severe error during pipeline creation", th);
                    throw th;
                }
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            ChannelFuture f = b.bind(host, port);
            log.info("Server binded host: {}, port: {}", (Object)host, (Object)port);
            f.sync();
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private void initializePlainTCPTransport(IMessaging messaging, Properties props) throws IOException {
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        int port = Integer.parseInt(props.getProperty("port"));
        this.initFactory(host, port, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) {
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeWebSocketTransport(IMessaging messaging, Properties props) throws IOException {
        String webSocketPortProp = props.getProperty("websocket_port");
        if (webSocketPortProp == null) {
            log.info("WebSocket is disabled");
            return;
        }
        int port = Integer.parseInt(webSocketPortProp);
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        this.initFactory(host, port, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) {
                pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler("/mqtt", "mqttv3.1, mqttv3.1.1"));
                pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
                pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeSSLTCPTransport(IMessaging messaging, Properties props, final SSLHandlerFactory sslHandlerFactory) throws IOException {
        String sslPortProp = props.getProperty("sslPort");
        sslPortProp = props.get("sslPort").toString();
        if (sslPortProp == null) {
            log.info("SSL is disabled");
            return;
        }
        int sslPort = Integer.parseInt(sslPortProp);
        log.info("Starting SSL on port {}", (Object)sslPort);
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        this.initFactory(host, sslPort, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) throws Exception {
                pipeline.addLast("ssl", sslHandlerFactory.create());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeWSSTransport(IMessaging messaging, Properties props, final SslHandler sslHandler) throws IOException {
        String sslPortProp = props.getProperty("secure_websocket_port");
        if (sslPortProp == null) {
            log.info("SSL is disabled");
            return;
        }
        int sslPort = Integer.parseInt(sslPortProp);
        final NettyMQTTHandler handler = new NettyMQTTHandler();
        handler.setMessaging(messaging);
        String host = props.getProperty("host");
        this.initFactory(host, sslPort, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) throws Exception {
                pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler("/mqtt", "mqttv3.1, mqttv3.1.1"));
                pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
                pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)new MoquetteIdleTimoutHandler());
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    @Override
    public void close() {
        if (this.m_workerGroup == null) {
            throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
        }
        if (this.m_bossGroup == null) {
            throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
        }
        this.m_workerGroup.shutdownGracefully();
        this.m_bossGroup.shutdownGracefully();
        MessageMetrics metrics = this.m_metricsCollector.computeMetrics();
        log.info("Msg read: {}, msg wrote: {}", (Object)metrics.messagesRead(), (Object)metrics.messagesWrote());
        BytesMetrics bytesMetrics = this.m_bytesMetricsCollector.computeMetrics();
        log.info(String.format("Bytes read: %d, bytes wrote: %d", bytesMetrics.readBytes(), bytesMetrics.wroteBytes()));
    }

    private SSLHandlerFactory initSSLHandlerFactory(Properties props) {
        SSLHandlerFactory factory = new SSLHandlerFactory(props);
        return factory.canCreate() ? factory : null;
    }

    abstract class PipelineInitializer {
        PipelineInitializer() {
        }

        abstract void init(ChannelPipeline var1) throws Exception;
    }

    static class ByteBufToWebSocketFrameEncoder
    extends MessageToMessageEncoder<ByteBuf> {
        ByteBufToWebSocketFrameEncoder() {
        }

        protected void encode(ChannelHandlerContext chc, ByteBuf bb, List<Object> out) throws Exception {
            BinaryWebSocketFrame result = new BinaryWebSocketFrame();
            result.content().writeBytes(bb);
            out.add(result);
        }
    }

    static class WebSocketFrameToByteBufDecoder
    extends MessageToMessageDecoder<BinaryWebSocketFrame> {
        WebSocketFrameToByteBufDecoder() {
        }

        protected void decode(ChannelHandlerContext chc, BinaryWebSocketFrame frame, List<Object> out) throws Exception {
            ByteBuf bb = frame.content();
            bb.retain();
            out.add(bb);
        }
    }
}

