/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.dna.mqtt.moquette.messaging.spi.impl.SimpleMessaging;
import org.dna.mqtt.moquette.server.ServerAcceptor;
import org.dna.mqtt.moquette.server.netty.NettyAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;

public class Server {
    public static final int DEFAULT_MQTT_PORT = 1833;
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private static final String DB_STORE_PATH = "/repository/database";
    public static final String STORAGE_FILE_PATH = System.getProperty("carbon.home") + "/repository/database" + File.separator + "mqtt_store.hawtdb";
    private ServerAcceptor m_acceptor;
    SimpleMessaging messaging;

    public void startServer(int port) throws IOException {
        if (((Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_ENABLED)).booleanValue()) {
            Properties configProps = this.loadConfigurations();
            configProps.put("port", Integer.toString(port));
            this.serverInit(configProps);
        } else {
            log.warn("MQTT Transport is disabled as per configuration.");
        }
    }

    public void startServer() throws IOException {
        Properties configProps = this.loadConfigurations();
        this.serverInit(configProps);
    }

    private Properties loadConfigurations() {
        Properties mqttProperties = new Properties();
        mqttProperties.put("sslPort", AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_DEFAULT_CONNECTION_PORT));
        mqttProperties.put("sslPort", AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_PORT));
        mqttProperties.put("sslEnabled", AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_ENABLED));
        mqttProperties.put("portEnabled", AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_DEFAULT_CONNECTION_ENABLED));
        mqttProperties.put("host", AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_BIND_ADDRESS));
        return mqttProperties;
    }

    private void serverInit(Properties configProps) throws IOException {
        this.messaging = SimpleMessaging.getInstance();
        this.messaging.init(configProps);
        this.m_acceptor = new NettyAcceptor();
        this.m_acceptor.initialize(this.messaging, configProps);
    }

    public void stopServer() {
        log.info("MQTT Server is stopping...");
        this.messaging.stop();
        this.m_acceptor.close();
        log.info("MQTT Server has stopped.");
    }
}

