/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.proto;

import org.dna.mqtt.moquette.proto.messages.AbstractMessage;

public class Utils {
    public static final int MAX_LENGTH_LIMIT = 0xFFFFFFF;

    static int numBytesToEncode(int len) {
        if (0 <= len && len <= 127) {
            return 1;
        }
        if (128 <= len && len <= 16383) {
            return 2;
        }
        if (16384 <= len && len <= 0x1FFFFF) {
            return 3;
        }
        if (0x200000 <= len && len <= 0xFFFFFFF) {
            return 4;
        }
        throw new IllegalArgumentException("value shoul be in the range [0..268435455]");
    }

    static byte encodeFlags(AbstractMessage message) {
        byte flags = 0;
        if (message.isDupFlag()) {
            flags = (byte)(flags | 8);
        }
        if (message.isRetainFlag()) {
            flags = (byte)(flags | 1);
        }
        flags = (byte)(flags | (message.getQos().ordinal() & 3) << 1);
        return flags;
    }

    public static String msgType2String(int type) {
        switch (type) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "CONNACK";
            }
            case 3: {
                return "PUBLISH";
            }
            case 4: {
                return "PUBACK";
            }
            case 5: {
                return "PUBREC";
            }
            case 6: {
                return "PUBREL";
            }
            case 7: {
                return "PUBCOMP";
            }
            case 8: {
                return "SUBSCRIBE";
            }
            case 9: {
                return "SUBACK";
            }
            case 10: {
                return "UNSUBSCRIBE";
            }
            case 11: {
                return "UNSUBACK";
            }
            case 12: {
                return "PINGREQ";
            }
            case 13: {
                return "PINGRESP";
            }
            case 14: {
                return "DISCONNECT";
            }
        }
        throw new RuntimeException("Can't decode message type " + type);
    }
}

