/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.parser.netty;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeMap;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dna.mqtt.moquette.parser.netty.DemuxDecoder;
import org.dna.mqtt.moquette.parser.netty.Utils;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.proto.messages.SubscribeMessage;

class SubscribeDecoder
extends DemuxDecoder {
    SubscribeDecoder() {
    }

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws Exception {
        SubscribeMessage message = new SubscribeMessage();
        in.resetReaderIndex();
        if (!this.decodeCommonHeader(message, 2, in)) {
            in.resetReaderIndex();
            return;
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new CorruptedFrameException("Received Subscribe message with QoS other than LEAST_ONE, was: " + (Object)((Object)message.getQos()));
        }
        int start = in.readerIndex();
        message.setMessageID(in.readUnsignedShort());
        int readed = in.readerIndex() - start;
        while (readed < message.getRemainingLength()) {
            this.decodeSubscription(in, message);
            readed = in.readerIndex() - start;
        }
        if (message.subscriptions().isEmpty()) {
            throw new CorruptedFrameException("subscribe MUST have got at least 1 couple topic/QoS");
        }
        out.add(message);
    }

    private void decodeSubscription(ByteBuf in, SubscribeMessage message) throws UnsupportedEncodingException {
        String topic = Utils.decodeString(in);
        byte qosByte = in.readByte();
        if ((qosByte & 0xFC) > 0) {
            throw new CorruptedFrameException("subscribe MUST have QoS byte with reserved buts to 0, found " + Integer.toHexString(qosByte));
        }
        byte qos = (byte)(qosByte & 3);
        message.addSubscription(new SubscribeMessage.Couple(qos, topic));
    }
}

