/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.parser.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.AttributeMap;
import java.util.List;
import org.dna.mqtt.moquette.parser.netty.DemuxDecoder;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.proto.messages.SubAckMessage;

class SubAckDecoder
extends DemuxDecoder {
    SubAckDecoder() {
    }

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws Exception {
        in.resetReaderIndex();
        SubAckMessage message = new SubAckMessage();
        if (!this.decodeCommonHeader(message, 0, in)) {
            in.resetReaderIndex();
            return;
        }
        int remainingLength = message.getRemainingLength();
        message.setMessageID(in.readUnsignedShort());
        if (in.readableBytes() < (remainingLength -= 2)) {
            in.resetReaderIndex();
            return;
        }
        for (int i = 0; i < remainingLength; ++i) {
            byte qos = in.readByte();
            message.addType(AbstractMessage.QOSType.values()[qos]);
        }
        out.add(message);
    }
}

