/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl.subscriptions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.dna.mqtt.moquette.messaging.spi.IPersistentSubscriptionStore;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.Subscription;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.Token;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionsStore {
    private TreeNode subscriptions = new TreeNode(null);
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionsStore.class);
    private IPersistentSubscriptionStore m_storageService;

    public void init(IPersistentSubscriptionStore storageService) {
        LOG.debug("init invoked");
        this.m_storageService = storageService;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reloading all stored subscriptions...subscription tree before {}", (Object)this.dumpTree());
        }
        for (Subscription subscription : this.m_storageService.retrieveAllSubscriptions()) {
            LOG.debug("Re-subscribing {} to topic {}", (Object)subscription.getClientId(), (Object)subscription.getTopic());
            this.addDirect(subscription);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished loading. Subscription tree after {}", (Object)this.dumpTree());
        }
    }

    protected void addDirect(Subscription newSubscription) {
        TreeNode current = this.findMatchingNode(newSubscription.topic);
        current.addSubscription(newSubscription);
    }

    private TreeNode findMatchingNode(String topic) {
        List<Object> tokens = new ArrayList();
        try {
            tokens = SubscriptionsStore.splitTopic(topic);
        }
        catch (ParseException ex) {
            LOG.error(null, (Throwable)ex);
        }
        TreeNode current = this.subscriptions;
        for (Token token : tokens) {
            TreeNode matchingChildren = current.childWithToken(token);
            if (matchingChildren != null) {
                current = matchingChildren;
                continue;
            }
            matchingChildren = new TreeNode(current);
            matchingChildren.setToken(token);
            current.addChild(matchingChildren);
            current = matchingChildren;
        }
        return current;
    }

    public void add(Subscription newSubscription) {
        this.addDirect(newSubscription);
        String clientID = newSubscription.getClientId();
        this.m_storageService.addNewSubscription(newSubscription, clientID);
    }

    public void removeSubscription(String topic, String clientID) {
        TreeNode matchNode = this.findMatchingNode(topic);
        Subscription toBeRemoved = null;
        for (Subscription sub : matchNode.subscriptions()) {
            if (!sub.topic.equals(topic) || !sub.getClientId().equals(clientID)) continue;
            toBeRemoved = sub;
            break;
        }
        if (toBeRemoved != null) {
            matchNode.subscriptions().remove(toBeRemoved);
        }
    }

    public Subscription getSubscriptions(String topic, String clientID) {
        Subscription subscription = null;
        TreeNode matchNode = this.findMatchingNode(topic);
        for (Subscription sub : matchNode.subscriptions()) {
            if (!sub.topic.equals(topic) || !sub.getClientId().equals(clientID)) continue;
            subscription = sub;
            break;
        }
        return subscription;
    }

    public void clearAllSubscriptions() {
        SubscriptionTreeCollector subsCollector = new SubscriptionTreeCollector();
        this.bfsVisit(this.subscriptions, subsCollector);
        Object allSubscriptions = subsCollector.getResult();
        Iterator iterator = allSubscriptions.iterator();
        while (iterator.hasNext()) {
            Subscription subscription = (Subscription)iterator.next();
            this.removeSubscription(subscription.getTopic(), subscription.getClientId());
        }
    }

    public void removeForClient(String clientID) {
        this.subscriptions.removeClientSubscriptions(clientID);
        this.m_storageService.removeAllSubscriptions(clientID);
    }

    public void deactivate(String clientID) {
        this.subscriptions.deactivate(clientID);
    }

    public void activate(String clientID) {
        LOG.debug("Activating subscriptions for clientID <{}>", (Object)clientID);
        this.subscriptions.activate(clientID);
    }

    public List<Subscription> matches(String topic) {
        List<Token> tokens;
        try {
            tokens = SubscriptionsStore.splitTopic(topic);
        }
        catch (ParseException ex) {
            LOG.error(null, (Throwable)ex);
            return Collections.EMPTY_LIST;
        }
        LinkedBlockingDeque<Token> tokenQueue = new LinkedBlockingDeque<Token>(tokens);
        ArrayList<Subscription> matchingSubs = new ArrayList<Subscription>();
        this.subscriptions.matches(tokenQueue, matchingSubs);
        return matchingSubs;
    }

    public boolean contains(Subscription sub) {
        return !this.matches(sub.topic).isEmpty();
    }

    public int size() {
        return this.subscriptions.size();
    }

    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.bfsVisit(this.subscriptions, visitor);
        return visitor.getResult();
    }

    private void bfsVisit(TreeNode node, IVisitor visitor) {
        if (node == null) {
            return;
        }
        visitor.visit(node);
        for (TreeNode child : node.m_children) {
            this.bfsVisit(child, visitor);
        }
    }

    public static boolean matchTopics(String msgTopic, String subscriptionTopic) {
        try {
            int i;
            List<Token> msgTokens = SubscriptionsStore.splitTopic(msgTopic);
            List<Token> subscriptionTokens = SubscriptionsStore.splitTopic(subscriptionTopic);
            Token subToken = null;
            for (i = 0; i < subscriptionTokens.size(); ++i) {
                subToken = subscriptionTokens.get(i);
                if (subToken != Token.MULTI && subToken != Token.SINGLE) {
                    if (i >= msgTokens.size()) {
                        return false;
                    }
                    Token msgToken = msgTokens.get(i);
                    if (msgToken.equals(subToken)) continue;
                    return false;
                }
                if (subToken == Token.MULTI) {
                    return true;
                }
                if (subToken != Token.SINGLE) continue;
            }
            return i == msgTokens.size();
        }
        catch (ParseException ex) {
            LOG.error(null, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected static List<Token> splitTopic(String topic) throws ParseException {
        ArrayList<Token> res = new ArrayList<Token>();
        String[] splitted = topic.split("/");
        if (splitted.length == 0) {
            res.add(Token.EMPTY);
        }
        for (int i = 0; i < splitted.length; ++i) {
            String s = splitted[i];
            if (s.isEmpty()) {
                res.add(Token.EMPTY);
                continue;
            }
            if (s.equals("#")) {
                if (i != splitted.length - 1) {
                    throw new ParseException("Bad format of topic, the multi symbol (#) has to be the last one after a separator", i);
                }
                res.add(Token.MULTI);
                continue;
            }
            if (s.contains("#")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            if (s.equals("+")) {
                res.add(Token.SINGLE);
                continue;
            }
            if (s.contains("+")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            res.add(new Token(s));
        }
        return res;
    }

    private class SubscriptionTreeCollector
    implements IVisitor<List<Subscription>> {
        private List<Subscription> m_allSubscriptions = new ArrayList<Subscription>();

        private SubscriptionTreeCollector() {
        }

        @Override
        public void visit(TreeNode node) {
            this.m_allSubscriptions.addAll(node.subscriptions());
        }

        @Override
        public List<Subscription> getResult() {
            return this.m_allSubscriptions;
        }
    }

    private class DumpTreeVisitor
    implements IVisitor<String> {
        String s = "";

        private DumpTreeVisitor() {
        }

        @Override
        public void visit(TreeNode node) {
            String subScriptionsStr = "";
            for (Subscription sub : node.m_subscriptions) {
                subScriptionsStr = subScriptionsStr + sub.toString();
            }
            this.s = this.s + (node.getToken() == null ? "" : node.getToken().toString());
            this.s = this.s + subScriptionsStr + "\n";
        }

        @Override
        public String getResult() {
            return this.s;
        }
    }

    public static interface IVisitor<T> {
        public void visit(TreeNode var1);

        public T getResult();
    }
}

