/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl.subscriptions;

import java.io.Serializable;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;

public class Subscription
implements Serializable {
    AbstractMessage.QOSType requestedQos;
    String clientId;
    String topic;
    boolean cleanSession;
    boolean active = true;

    public Subscription(String clientId, String topic, AbstractMessage.QOSType requestedQos, boolean cleanSession) {
        this.requestedQos = requestedQos;
        this.clientId = clientId;
        this.topic = topic;
        this.cleanSession = cleanSession;
    }

    public String getClientId() {
        return this.clientId;
    }

    public AbstractMessage.QOSType getRequestedQos() {
        return this.requestedQos;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (this.requestedQos != other.requestedQos) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.requestedQos != null ? this.requestedQos.hashCode() : 0);
        hash = 37 * hash + (this.clientId != null ? this.clientId.hashCode() : 0);
        hash = 37 * hash + (this.topic != null ? this.topic.hashCode() : 0);
        return hash;
    }

    boolean match(String topic) {
        return this.topic.equals(topic);
    }

    public String toString() {
        return String.format("[t:%s, cliID: %s, qos: %s, active: %s]", new Object[]{this.topic, this.clientId, this.requestedQos, this.active});
    }
}

