/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl.events;

import java.nio.ByteBuffer;
import org.dna.mqtt.moquette.messaging.spi.impl.events.MessagingEvent;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.proto.messages.PublishMessage;
import org.dna.mqtt.moquette.server.ServerChannel;

public class PublishEvent
extends MessagingEvent {
    String m_topic;
    AbstractMessage.QOSType m_qos;
    ByteBuffer m_message;
    boolean m_retain;
    String m_clientID;
    int m_msgID;
    transient ServerChannel m_session;

    public PublishEvent(PublishMessage pubMsg, String clientID, ServerChannel session) {
        this.m_topic = pubMsg.getTopicName();
        this.m_qos = pubMsg.getQos();
        this.m_message = pubMsg.getPayload();
        this.m_retain = pubMsg.isRetainFlag();
        this.m_clientID = clientID;
        this.m_session = session;
        if (pubMsg.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            this.m_msgID = pubMsg.getMessageID();
        }
    }

    public PublishEvent(String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retain, String clientID, ServerChannel session) {
        this.m_topic = topic;
        this.m_qos = qos;
        this.m_message = message;
        this.m_retain = retain;
        this.m_clientID = clientID;
        this.m_session = session;
    }

    public PublishEvent(String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retain, String clientID, int msgID, ServerChannel session) {
        this(topic, qos, message, retain, clientID, session);
        this.m_msgID = msgID;
    }

    public String getTopic() {
        return this.m_topic;
    }

    public AbstractMessage.QOSType getQos() {
        return this.m_qos;
    }

    public ByteBuffer getMessage() {
        return this.m_message;
    }

    public boolean isRetain() {
        return this.m_retain;
    }

    public String getClientID() {
        return this.m_clientID;
    }

    public int getMessageID() {
        return this.m_msgID;
    }

    public ServerChannel getSession() {
        return this.m_session;
    }

    public String toString() {
        return "PublishEvent{m_msgID=" + this.m_msgID + ", m_clientID='" + this.m_clientID + '\'' + ", m_retain=" + this.m_retain + ", m_qos=" + (Object)((Object)this.m_qos) + ", m_topic='" + this.m_topic + '\'' + '}';
    }
}

