/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.messaging.spi.IMessaging;
import org.dna.mqtt.moquette.messaging.spi.IStorageService;
import org.dna.mqtt.moquette.messaging.spi.impl.HawtDBStorageService;
import org.dna.mqtt.moquette.messaging.spi.impl.ProtocolProcessor;
import org.dna.mqtt.moquette.messaging.spi.impl.ValueEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.DisconnectEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.InitEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.LostConnectionEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.MessagingEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.ProtocolEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.PublishEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.StopEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.SubscriptionsStore;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.proto.messages.ConnectMessage;
import org.dna.mqtt.moquette.proto.messages.DisconnectMessage;
import org.dna.mqtt.moquette.proto.messages.PubAckMessage;
import org.dna.mqtt.moquette.proto.messages.PubCompMessage;
import org.dna.mqtt.moquette.proto.messages.PubRecMessage;
import org.dna.mqtt.moquette.proto.messages.PubRelMessage;
import org.dna.mqtt.moquette.proto.messages.PublishMessage;
import org.dna.mqtt.moquette.proto.messages.SubscribeMessage;
import org.dna.mqtt.moquette.proto.messages.UnsubscribeMessage;
import org.dna.mqtt.moquette.server.IAuthenticator;
import org.dna.mqtt.moquette.server.ServerChannel;
import org.dna.mqtt.wso2.MQTTPingRequest;
import org.dna.mqtt.wso2.MQTTSubscriptionStore;
import org.dna.mqtt.wso2.MqttLogExceptionHandler;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;

public class SimpleMessaging
implements IMessaging,
EventHandler<ValueEvent> {
    private static Log log = LogFactory.getLog(SimpleMessaging.class);
    private SubscriptionsStore subscriptions;
    private RingBuffer<ValueEvent> m_ringBuffer;
    private IStorageService m_storageService;
    private Disruptor<ValueEvent> disruptor;
    private static SimpleMessaging INSTANCE;
    private ProtocolProcessor mqttProcessor = new ProtocolProcessor();
    CountDownLatch m_stopLatch;

    private SimpleMessaging() {
    }

    public static SimpleMessaging getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SimpleMessaging();
        }
        return INSTANCE;
    }

    public void init(Properties configProps) {
        this.subscriptions = new MQTTSubscriptionStore();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Disruptor MQTT Simple Messaging Thread %d").build();
        ExecutorService executor = Executors.newCachedThreadPool(namedThreadFactory);
        Integer ringBufferSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_INBOUND_BUFFER_SIZE);
        this.disruptor = new Disruptor(ValueEvent.EVENT_FACTORY, ringBufferSize.intValue(), (Executor)executor);
        this.disruptor.handleExceptionsWith((ExceptionHandler)new MqttLogExceptionHandler());
        SequenceBarrier barrier = this.disruptor.getRingBuffer().newBarrier(new Sequence[0]);
        BatchEventProcessor eventProcessor = new BatchEventProcessor((DataProvider)this.disruptor.getRingBuffer(), barrier, (EventHandler)this);
        eventProcessor.setExceptionHandler((ExceptionHandler)new MqttLogExceptionHandler());
        this.disruptor.handleEventsWith(new EventProcessor[]{eventProcessor});
        this.m_ringBuffer = this.disruptor.start();
        this.disruptorPublish(new InitEvent(configProps));
    }

    private void disruptorPublish(MessagingEvent msgEvent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disruptorPublish publishing event " + msgEvent));
        }
        long sequence = this.m_ringBuffer.next();
        ValueEvent event = (ValueEvent)this.m_ringBuffer.get(sequence);
        event.setEvent(msgEvent);
        this.m_ringBuffer.publish(sequence);
    }

    @Override
    public void disconnect(ServerChannel session) {
        this.disruptorPublish(new DisconnectEvent(session));
    }

    @Override
    public void lostConnection(String clientID) {
        this.disruptorPublish(new LostConnectionEvent(clientID));
    }

    @Override
    public void handleProtocolMessage(ServerChannel session, AbstractMessage msg) {
        this.disruptorPublish(new ProtocolEvent(session, msg));
    }

    @Override
    public void stop() {
        this.m_stopLatch = new CountDownLatch(1);
        this.disruptorPublish(new StopEvent());
        try {
            boolean elapsed;
            boolean bl = elapsed = !this.m_stopLatch.await(10L, TimeUnit.SECONDS);
            if (elapsed) {
                log.warn((Object)"Can't stop the server in 10 seconds");
            }
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(ValueEvent t, long l, boolean bln) throws Exception {
        MessagingEvent evt = t.getEvent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("onEvent processing messaging event from input ringbuffer " + evt));
        }
        if (evt instanceof PublishEvent) {
            this.mqttProcessor.processPublish((PublishEvent)evt);
            return;
        } else if (evt instanceof StopEvent) {
            this.processStop();
            return;
        } else if (evt instanceof DisconnectEvent) {
            DisconnectEvent disEvt = (DisconnectEvent)evt;
            String clientID = (String)disEvt.getSession().getAttribute("ClientID");
            this.mqttProcessor.processDisconnect(disEvt.getSession(), clientID, false);
            return;
        } else if (evt instanceof ProtocolEvent) {
            ServerChannel session = ((ProtocolEvent)evt).getSession();
            AbstractMessage message = ((ProtocolEvent)evt).getMessage();
            if (message instanceof ConnectMessage) {
                this.mqttProcessor.processConnect(session, (ConnectMessage)message);
                return;
            } else if (message instanceof PublishMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                PublishEvent pubEvt = new PublishEvent((PublishMessage)message, clientID, session);
                this.mqttProcessor.processPublish(pubEvt);
                return;
            } else if (message instanceof DisconnectMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                boolean cleanSession = (Boolean)session.getAttribute("cleanSession");
                this.mqttProcessor.processDisconnect(session, clientID, cleanSession);
                return;
            } else if (message instanceof UnsubscribeMessage) {
                UnsubscribeMessage unsubMsg = (UnsubscribeMessage)message;
                String clientID = (String)session.getAttribute("ClientID");
                this.mqttProcessor.processUnsubscribe(session, clientID, unsubMsg.topicFilters(), unsubMsg.getMessageID());
                return;
            } else if (message instanceof SubscribeMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                boolean cleanSession = (Boolean)session.getAttribute("cleanSession");
                this.mqttProcessor.processSubscribe(session, (SubscribeMessage)message, clientID, cleanSession);
                return;
            } else if (message instanceof PubRelMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                int messageID = ((PubRelMessage)message).getMessageID();
                this.mqttProcessor.processPubRel(clientID, messageID);
                return;
            } else if (message instanceof PubRecMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                int messageID = ((PubRecMessage)message).getMessageID();
                this.mqttProcessor.processPubRec(clientID, messageID);
                return;
            } else if (message instanceof PubCompMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                int messageID = ((PubCompMessage)message).getMessageID();
                this.mqttProcessor.processPubComp(clientID, messageID);
                return;
            } else if (message instanceof PubAckMessage) {
                String clientID = (String)session.getAttribute("ClientID");
                int messageID = ((PubAckMessage)message).getMessageID();
                this.mqttProcessor.processPubAck(clientID, messageID);
                return;
            } else {
                if (!(message instanceof MQTTPingRequest)) throw new RuntimeException("Illegal message received " + message);
                String clientID = ((MQTTPingRequest)message).getChannelId();
                this.mqttProcessor.pingRequestReceived(clientID);
            }
            return;
        } else if (evt instanceof InitEvent) {
            this.processInit(((InitEvent)evt).getConfig());
            return;
        } else {
            if (!(evt instanceof LostConnectionEvent)) return;
            LostConnectionEvent lostEvt = (LostConnectionEvent)evt;
            this.mqttProcessor.proccessConnectionLost(lostEvt.getClientID());
        }
    }

    private void processInit(Properties props) {
        this.m_storageService = new HawtDBStorageService();
        this.m_storageService.initStore();
        this.subscriptions.init(this.m_storageService);
        String authenticatorClassName = (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_USER_AUTHENTICATOR_CLASS);
        try {
            Class<IAuthenticator> authenticatorClass = Class.forName(authenticatorClassName).asSubclass(IAuthenticator.class);
            IAuthenticator authenticator = authenticatorClass.newInstance();
            this.mqttProcessor.init(this.subscriptions, this.m_storageService, authenticator);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unable to find the class authenticator: " + authenticatorClassName, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to create an instance of :" + authenticatorClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to create an instance of :", e);
        }
    }

    private void processStop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"processStop invoked");
        }
        this.m_storageService.close();
        this.disruptor.shutdown();
        this.subscriptions = null;
        this.m_stopLatch.countDown();
    }
}

