/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.dsl.Disruptor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.messaging.spi.IStorageService;
import org.dna.mqtt.moquette.messaging.spi.impl.DebugUtils;
import org.dna.mqtt.moquette.messaging.spi.impl.ValueEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.MessagingEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.OutputMessagingEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.events.PublishEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.Subscription;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.SubscriptionsStore;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.proto.messages.ConnAckMessage;
import org.dna.mqtt.moquette.proto.messages.ConnectMessage;
import org.dna.mqtt.moquette.proto.messages.PubAckMessage;
import org.dna.mqtt.moquette.proto.messages.PubCompMessage;
import org.dna.mqtt.moquette.proto.messages.PubRecMessage;
import org.dna.mqtt.moquette.proto.messages.PubRelMessage;
import org.dna.mqtt.moquette.proto.messages.PublishMessage;
import org.dna.mqtt.moquette.proto.messages.SubAckMessage;
import org.dna.mqtt.moquette.proto.messages.SubscribeMessage;
import org.dna.mqtt.moquette.proto.messages.UnsubAckMessage;
import org.dna.mqtt.moquette.server.AuthenticationInfo;
import org.dna.mqtt.moquette.server.ConnectionDescriptor;
import org.dna.mqtt.moquette.server.IAuthenticator;
import org.dna.mqtt.moquette.server.IAuthorizer;
import org.dna.mqtt.moquette.server.ServerChannel;
import org.dna.mqtt.moquette.server.netty.exception.MQTTInitializationException;
import org.dna.mqtt.wso2.AndesMQTTBridge;
import org.dna.mqtt.wso2.MqttLogExceptionHandler;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.enums.MQTTAuthoriztionPermissionLevel;
import org.wso2.andes.configuration.enums.MQTTUserAuthenticationScheme;
import org.wso2.andes.configuration.enums.MQTTUserAuthorizationScheme;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.mqtt.MQTTAuthorizationSubject;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.utils.MQTTUtils;

public class ProtocolProcessor
implements EventHandler<ValueEvent>,
PubAckHandler {
    private static Log log = LogFactory.getLog(ProtocolProcessor.class);
    public static final String CARBON_SUPER_TENANT_DOMAIN = "carbon.super";
    private Map<String, ConnectionDescriptor> m_clientIDs = new HashMap<String, ConnectionDescriptor>();
    private SubscriptionsStore subscriptions;
    private IStorageService m_storageService;
    private IAuthenticator m_authenticator;
    private IAuthorizer m_authorizer;
    private Map<String, MQTTAuthorizationSubject> authSubjects = new HashMap<String, MQTTAuthorizationSubject>();
    private Map<String, ServerChannel> forciblyClosedChannels = new HashMap<String, ServerChannel>();
    private RingBuffer<ValueEvent> m_ringBuffer;
    private boolean isAuthenticationRequired;
    private boolean isAuthorizationRequired;

    ProtocolProcessor() {
    }

    void init(SubscriptionsStore subscriptions, IStorageService storageService, IAuthenticator authenticator) {
        this.subscriptions = subscriptions;
        this.m_authenticator = authenticator;
        this.m_storageService = storageService;
        this.isAuthenticationRequired = AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_USER_AUTHENTICATION) == MQTTUserAuthenticationScheme.REQUIRED;
        boolean bl = this.isAuthorizationRequired = AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_USER_AUTHORIZATION) == MQTTUserAuthorizationScheme.REQUIRED;
        if (this.isAuthorizationRequired) {
            String authorizerClassName = (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_USER_AUTHORIZATION_CLASS);
            try {
                Class<IAuthorizer> authorizerClass = Class.forName(authorizerClassName).asSubclass(IAuthorizer.class);
                this.m_authorizer = authorizerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new MQTTInitializationException("Unable to find the class authorizer: " + authorizerClassName, e);
            }
            catch (InstantiationException e) {
                throw new MQTTInitializationException("Unable to create an instance of :" + authorizerClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new MQTTInitializationException("Access of the instance in not allowed.", e);
            }
        }
        Integer RingBufferSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_DELIVERY_BUFFER_SIZE);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Disruptor MQTT Protocol Processor thread %d").build();
        ExecutorService executor = Executors.newCachedThreadPool(namedThreadFactory);
        Disruptor disruptor = new Disruptor(ValueEvent.EVENT_FACTORY, RingBufferSize.intValue(), (Executor)executor);
        disruptor.handleExceptionsWith((ExceptionHandler)new MqttLogExceptionHandler());
        SequenceBarrier barrier = disruptor.getRingBuffer().newBarrier(new Sequence[0]);
        BatchEventProcessor m_eventProcessor = new BatchEventProcessor((DataProvider)disruptor.getRingBuffer(), barrier, (EventHandler)this);
        m_eventProcessor.setExceptionHandler((ExceptionHandler)new MqttLogExceptionHandler());
        disruptor.handleEventsWith(new EventProcessor[]{m_eventProcessor});
        this.m_ringBuffer = disruptor.start();
        this.initAndesBridge(subscriptions, storageService);
    }

    private void initAndesBridge(SubscriptionsStore subscriptions, IStorageService storageService) {
        try {
            AndesMQTTBridge.initMQTTProtocolProcessor(this);
        }
        catch (MQTTException e) {
            String message = "Error occurred when initializing MQTT connection with Andes ";
            log.error((Object)("Error occurred when initializing MQTT connection with Andes " + e.getMessage()), (Throwable)e);
        }
        subscriptions.clearAllSubscriptions();
    }

    void processConnect(ServerChannel session, ConnectMessage msg) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processConnect for client " + msg.getClientID()));
        }
        if (msg.getProcotolVersion() != 3 && msg.getProcotolVersion() != 4) {
            ConnAckMessage badProto = new ConnAckMessage();
            badProto.setReturnCode((byte)1);
            log.warn((Object)"processConnect sent bad proto ConnAck");
            session.write(badProto);
            session.close(false);
            return;
        }
        if (msg.getClientID() == null || msg.getClientID().length() == 0) {
            ConnAckMessage okResp = new ConnAckMessage();
            okResp.setReturnCode((byte)2);
            session.write(okResp);
            return;
        }
        if (this.isAuthenticationRequired && !msg.isUserFlag()) {
            ConnAckMessage okResp = new ConnAckMessage();
            okResp.setReturnCode((byte)4);
            session.write(okResp);
            return;
        }
        if (this.m_clientIDs.containsKey(msg.getClientID())) {
            ServerChannel oldSession = this.m_clientIDs.get(msg.getClientID()).getSession();
            boolean cleanSession = (Boolean)oldSession.getAttribute("cleanSession");
            this.processDisconnect(oldSession, msg.getClientID(), cleanSession);
            this.forciblyClosedChannels.put(msg.getClientID(), oldSession);
        }
        ConnectionDescriptor connDescr = new ConnectionDescriptor(msg.getClientID(), session, msg.isCleanSession());
        this.m_clientIDs.put(msg.getClientID(), connDescr);
        int keepAlive = msg.getKeepAlive();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connect with keepAlive " + keepAlive));
        }
        session.setAttribute("keepAlive", keepAlive);
        session.setAttribute("cleanSession", msg.isCleanSession());
        session.setAttribute("ClientID", msg.getClientID());
        session.setIdleTime(Math.round((float)keepAlive * 1.5f));
        if (msg.isWillFlag()) {
            log.warn((Object)"Andes does not support last will operation");
        }
        MQTTAuthorizationSubject authSubject = new MQTTAuthorizationSubject(msg.getClientID(), msg.isUserFlag());
        if (msg.isUserFlag()) {
            boolean isAuthorized;
            AuthenticationInfo authenticationInfo;
            String username = msg.getUsername();
            String pwd = null;
            if (msg.isPasswordFlag()) {
                pwd = msg.getPassword();
            }
            if ((authenticationInfo = this.m_authenticator.checkValid(username, pwd)) == null || !authenticationInfo.isAuthenticated()) {
                ConnAckMessage okResp = new ConnAckMessage();
                okResp.setReturnCode((byte)4);
                session.write(okResp);
                return;
            }
            authSubject.setUsername(authenticationInfo.getUsername());
            authSubject.setTenantDomain(authenticationInfo.getTenantDomain());
            authSubject.setProtocolVersion(msg.getProcotolVersion());
            authSubject.setProperties(authenticationInfo.getProperties());
            if (this.isAuthorizationRequired && this.m_authorizer != null && !(isAuthorized = this.m_authorizer.isAuthorizedToConnect(authSubject))) {
                ConnAckMessage okResp = new ConnAckMessage();
                okResp.setReturnCode((byte)5);
                session.write(okResp);
                return;
            }
        }
        this.authSubjects.put(msg.getClientID(), authSubject);
        this.subscriptions.activate(msg.getClientID());
        if (msg.isCleanSession()) {
            this.processRemoveAllSubscriptions(msg.getClientID());
        }
        ConnAckMessage okResp = new ConnAckMessage();
        okResp.setReturnCode((byte)0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("processConnect sent OK ConnAck for client " + msg.getClientID()));
        }
        session.write(okResp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connected client ID " + msg.getClientID() + " with clean session " + msg.isCleanSession()));
        }
        if (!msg.isCleanSession()) {
            this.republishStored(msg.getClientID());
        }
    }

    private void failedCredentials(ServerChannel session) {
        ConnAckMessage okResp = new ConnAckMessage();
        okResp.setReturnCode((byte)4);
        session.write(okResp);
        session.close(false);
    }

    private void republishStored(String clientID) {
        List<PublishEvent> publishedEvents;
        if (log.isTraceEnabled()) {
            log.trace((Object)("republishStored invoked for client " + clientID));
        }
        if ((publishedEvents = this.m_storageService.retrivePersistedPublishes(clientID)) == null) {
            log.info((Object)("No stored messages for client " + clientID));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("republishing stored messages to client " + clientID));
        }
        for (PublishEvent pubEvt : publishedEvents) {
            this.sendPublish(pubEvt.getClientID(), pubEvt.getTopic(), pubEvt.getQos(), pubEvt.getMessage(), false, pubEvt.getMessageID());
        }
    }

    public void pingRequestReceived(String clientID) {
        try {
            AndesMQTTBridge.getBridgeInstance().onProcessPingRequest(clientID);
        }
        catch (MQTTException e) {
            log.error((Object)"Error occurred while processing the ping request", (Throwable)e);
        }
    }

    void processPubAck(String clientID, int messageID) {
        try {
            AndesMQTTBridge.getBridgeInstance().onAckReceived(clientID, messageID);
        }
        catch (MQTTException e) {
            String message = "Error while receiving ack from the client " + clientID + " for message " + messageID;
            log.error((Object)message, (Throwable)e);
        }
    }

    private void processRemoveAllSubscriptions(String clientID) {
        log.info((Object)("cleaning old saved subscriptions for client " + clientID));
        this.subscriptions.removeForClient(clientID);
    }

    protected void processPublish(PublishEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPublish invoked with " + evt));
        }
        String topic = evt.getTopic();
        String clientID = evt.getClientID();
        MQTTAuthorizationSubject authSubject = this.authSubjects.get(clientID);
        String tenant = MQTTUtils.getTenantFromTopic(topic);
        boolean authenticated = false;
        boolean authorized = false;
        if (!this.isAuthenticationRequired && !authSubject.isUserFlag() || authSubject.isUserFlag() && (CARBON_SUPER_TENANT_DOMAIN.equals(authSubject.getTenantDomain()) || tenant.equals(authSubject.getTenantDomain()))) {
            authenticated = true;
            authorized = this.isAuthorizationRequired && this.m_authorizer != null ? this.m_authorizer.isAuthorizedForTopic(authSubject, topic, MQTTAuthoriztionPermissionLevel.PUBLISH) : true;
        }
        if (authenticated && authorized) {
            AbstractMessage.QOSType qos = evt.getQos();
            if (qos == AbstractMessage.QOSType.EXACTLY_ONCE) {
                String publishKey = String.format("%s%d", evt.getClientID(), evt.getMessageID());
                this.m_storageService.persistQoS2Message(publishKey, evt);
                this.sendPubRec(evt.getClientID(), evt.getMessageID());
            } else {
                AndesMQTTBridge.onMessagePublished(topic, qos.ordinal(), evt.getMessage(), evt.isRetain(), evt.getMessageID(), clientID, this, evt.getSession().getSocketChannel());
            }
        } else {
            log.error((Object)("Client " + clientID + " does not have permission to publish to topic : " + topic));
        }
    }

    public void publishToSubscriber(String subscribedDestination, String messageDestination, AbstractMessage.QOSType qos, ByteBuffer message, boolean retain, Integer messageID, String mqttClientID) throws MQTTException {
        Subscription subscription = this.subscriptions.getSubscriptions(subscribedDestination, mqttClientID);
        if (subscription != null) {
            if (qos.ordinal() > subscription.getRequestedQos().ordinal()) {
                qos = subscription.getRequestedQos();
            }
            if (qos == AbstractMessage.QOSType.MOST_ONE && subscription.isActive()) {
                this.sendPublish(subscription.getClientId(), messageDestination, qos, message, retain);
            } else if (!subscription.isCleanSession() && !subscription.isActive()) {
                PublishEvent newPublishEvt = new PublishEvent(subscribedDestination, qos, message, retain, subscription.getClientId(), messageID, null);
                this.m_storageService.storePublishForFuture(newPublishEvt);
            } else if (subscription.isActive()) {
                this.sendPublish(subscription.getClientId(), messageDestination, qos, message, retain, messageID);
            }
        } else {
            throw new MQTTException("Subscriber disconnected unexpectedly, will not deliver the message");
        }
    }

    @Deprecated
    public void publish2Subscribers(String topic, AbstractMessage.QOSType qos, ByteBuffer origMessage, boolean retain, Integer messageID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("publish2Subscribers republishing to existing subscribers that matches the topic " + topic));
            log.debug((Object)("content " + DebugUtils.payload2Str(origMessage)));
            log.debug((Object)("subscription tree " + this.subscriptions.dumpTree()));
        }
        for (Subscription sub : this.subscriptions.matches(topic)) {
            if (qos.ordinal() > sub.getRequestedQos().ordinal()) {
                qos = sub.getRequestedQos();
            }
            ByteBuffer message = origMessage.duplicate();
            if (qos == AbstractMessage.QOSType.MOST_ONE && sub.isActive()) {
                this.sendPublish(sub.getClientId(), topic, qos, message, false);
                continue;
            }
            if (!sub.isCleanSession() && !sub.isActive()) {
                PublishEvent newPublishEvt = new PublishEvent(topic, qos, message, retain, sub.getClientId(), messageID, null);
                this.m_storageService.storePublishForFuture(newPublishEvt);
                continue;
            }
            if (qos == AbstractMessage.QOSType.EXACTLY_ONCE) {
                String publishKey = String.format("%s%d", sub.getClientId(), messageID);
                PublishEvent newPublishEvt = new PublishEvent(topic, qos, message, retain, sub.getClientId(), messageID, null);
                this.m_storageService.addInFlight(newPublishEvt, publishKey);
            }
            if (!sub.isActive()) continue;
            this.sendPublish(sub.getClientId(), topic, qos, message, false);
        }
    }

    private void sendPublish(String clientId, String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retained) {
        int messageID = 1;
        this.sendPublish(clientId, topic, qos, message, retained, messageID);
    }

    private void sendPublish(String clientId, String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retained, int messageID) {
        PublishMessage pubMessage = new PublishMessage();
        pubMessage.setRetainFlag(retained);
        pubMessage.setTopicName(topic);
        pubMessage.setQos(qos);
        pubMessage.setPayload(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("send publish message to " + clientId + " on topic " + topic));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("content " + DebugUtils.payload2Str(message)));
        }
        if (pubMessage.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            pubMessage.setMessageID(messageID);
        }
        if (this.m_clientIDs == null) {
            throw new RuntimeException("Internal bad error, found m_clientIDs to null while it should be initialized, somewhere it's overwritten!!");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("clientIDs are " + this.m_clientIDs));
        }
        if (this.m_clientIDs.get(clientId) == null) {
            throw new RuntimeException(String.format("Can't find a ConnectionDescriptor for client <%s> in cache <%s>", clientId, this.m_clientIDs));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session for clientId" + clientId + "is " + this.m_clientIDs.get(clientId).getSession()));
        }
        this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientId).getSession(), pubMessage));
    }

    private void sendPubRec(String clientID, int messageID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SendPubRec invoked for clientID " + clientID + " with messageID " + messageID));
        }
        PubRecMessage pubRecMessage = new PubRecMessage();
        pubRecMessage.setMessageID(messageID);
        this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientID).getSession(), pubRecMessage));
    }

    private void sendPubAck(String clientId, int messageID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"sendPubAck invoked");
        }
        PubAckMessage pubAckMessage = new PubAckMessage();
        pubAckMessage.setMessageID(messageID);
        try {
            if (this.m_clientIDs == null) {
                throw new RuntimeException("Internal bad error, found m_clientIDs to null while it should be initialized, somewhere it's overwritten!!");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("clientIDs are " + this.m_clientIDs));
            }
            if (this.m_clientIDs.get(clientId) == null) {
                throw new RuntimeException(String.format("Can't find a ConnectionDEwcriptor for client %s in cache %s", clientId, this.m_clientIDs));
            }
            this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientId).getSession(), pubAckMessage));
        }
        catch (Throwable t) {
            log.error(null, t);
        }
    }

    void processPubRel(String clientID, int messageID) {
        String publishKey;
        PublishEvent evt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessPubRel invoked for clientID " + clientID + "ad messageID " + messageID));
        }
        if (null != (evt = this.m_storageService.retrieveQoS2Message(publishKey = String.format("%s%d", clientID, messageID)))) {
            String topic = evt.getTopic();
            AbstractMessage.QOSType qos = evt.getQos();
            AndesMQTTBridge.onMessagePublished(topic, qos.ordinal(), evt.getMessage(), evt.isRetain(), evt.getMessageID(), clientID, this, null);
            this.m_storageService.removeQoS2Message(publishKey);
        } else {
            log.warn((Object)("A PUBREL was received for message id " + messageID + " from client " + clientID + " the state has not being identified, no action will be taken"));
        }
    }

    private void sendPubComp(String clientID, int messageID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SendPubComp invoked for clientID " + clientID + " ad messageID " + messageID));
        }
        PubCompMessage pubCompMessage = new PubCompMessage();
        pubCompMessage.setMessageID(messageID);
        this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientID).getSession(), pubCompMessage));
    }

    void processPubRec(String clientID, int messageID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessPubRec invoked for " + clientID + " ad messageID " + messageID));
        }
        PubRelMessage pubRelMessage = new PubRelMessage();
        pubRelMessage.setMessageID(messageID);
        pubRelMessage.setQos(AbstractMessage.QOSType.LEAST_ONE);
        this.disruptorPublish(new OutputMessagingEvent(this.m_clientIDs.get(clientID).getSession(), pubRelMessage));
    }

    void processPubComp(String clientID, int messageID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessPubComp invoked for clientID " + clientID + " ad messageID " + messageID));
        }
        try {
            AndesMQTTBridge.getBridgeInstance().onAckReceived(clientID, messageID);
        }
        catch (MQTTException e) {
            log.error((Object)("Error while processing ack from the client " + clientID + " for message" + messageID), (Throwable)e);
        }
    }

    void processDisconnect(ServerChannel session, String clientID, boolean cleanSession) throws InterruptedException {
        String username = this.authSubjects.get(clientID).getUsername();
        this.removeAuthorizationSubject(clientID);
        if (cleanSession) {
            this.processRemoveAllSubscriptions(clientID);
        }
        this.m_clientIDs.remove(clientID);
        session.close(true);
        this.subscriptions.deactivate(clientID);
        try {
            AndesMQTTBridge.getBridgeInstance().onClientDisconnection(clientID, null, username, AndesMQTTBridge.SubscriptionEvent.DISCONNECT);
            log.info((Object)("Disconnected client " + clientID + " with clean session " + cleanSession));
        }
        catch (MQTTException e) {
            log.error((Object)"Error occurred when attempting to disconnect subscriber", (Throwable)e);
        }
    }

    void proccessConnectionLost(String clientID) {
        boolean forciblyClosed = false;
        if (this.forciblyClosedChannels.containsKey(clientID)) {
            ServerChannel oldSession = this.forciblyClosedChannels.remove(clientID);
            ServerChannel newSession = this.m_clientIDs.get(clientID).getSession();
            if (null != newSession && !oldSession.getUUID().equals(newSession.getUUID())) {
                forciblyClosed = true;
            }
        }
        if (!forciblyClosed && this.m_clientIDs.remove(clientID) != null) {
            this.subscriptions.deactivate(clientID);
            log.info((Object)("Lost connection with client " + clientID));
            try {
                if (this.authSubjects.containsKey(clientID)) {
                    String username = this.authSubjects.get(clientID).getUsername();
                    AndesMQTTBridge.getBridgeInstance().onClientDisconnection(clientID, null, username, AndesMQTTBridge.SubscriptionEvent.DISCONNECT);
                }
            }
            catch (MQTTException e) {
                String message = "Error occurred when attempting to disconnect subscriber ";
                log.error((Object)("Error occurred when attempting to disconnect subscriber " + e.getMessage()), (Throwable)e);
            }
            this.removeAuthorizationSubject(clientID);
        }
    }

    private void removeAuthorizationSubject(String clientID) {
        MQTTAuthorizationSubject removedAuthorizationSubject = this.authSubjects.remove(clientID);
        if (null == removedAuthorizationSubject) {
            log.warn((Object)("MQTTAuthorizationSubject for client ID " + clientID + " is not removed since the entry does not exist"));
        }
    }

    void processUnsubscribe(ServerChannel session, String clientID, List<String> topics, int messageID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processUnsubscribe invoked, removing subscription on topics " + topics + ", for clientID " + clientID));
        }
        for (String topic : topics) {
            this.subscriptions.removeSubscription(topic, clientID);
            try {
                AndesMQTTBridge.getBridgeInstance().onClientDisconnection(clientID, topic, this.authSubjects.get(clientID).getUsername(), AndesMQTTBridge.SubscriptionEvent.UNSUBSCRIBE);
            }
            catch (Exception e) {
                String message = "Error occurred when disconnecting the subscriber ";
                log.error((Object)("Error occurred when disconnecting the subscriber " + e.getMessage()));
            }
        }
        UnsubAckMessage ackMessage = new UnsubAckMessage();
        ackMessage.setMessageID(messageID);
        log.info((Object)("replying with UnsubAck to MSG ID " + messageID));
        session.write(ackMessage);
    }

    void processSubscribe(ServerChannel session, SubscribeMessage msg, String clientID, boolean cleanSession) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processSubscribe invoked from client " + clientID + " with msgID " + msg.getMessageID()));
        }
        MQTTAuthorizationSubject authSubject = this.authSubjects.get(clientID);
        SubAckMessage ackMessage = new SubAckMessage();
        ackMessage.setMessageID(msg.getMessageID());
        if (authSubject == null) {
            ackMessage.addType(AbstractMessage.QOSType.FAILURE);
            session.write(ackMessage);
            return;
        }
        for (SubscribeMessage.Couple req : msg.subscriptions()) {
            String tenant = MQTTUtils.getTenantFromTopic(req.getTopicFilter());
            if (!this.isAuthenticationRequired && !authSubject.isUserFlag() || authSubject.isUserFlag() && (CARBON_SUPER_TENANT_DOMAIN.equals(authSubject.getTenantDomain()) || tenant.equals(authSubject.getTenantDomain()))) {
                boolean authorized = this.isAuthorizationRequired && this.m_authorizer != null ? this.m_authorizer.isAuthorizedForTopic(authSubject, req.getTopicFilter(), MQTTAuthoriztionPermissionLevel.SUBSCRIBE) : true;
                AbstractMessage.QOSType qos = AbstractMessage.QOSType.values()[req.getQos()];
                ackMessage.addType(authorized ? qos : AbstractMessage.QOSType.FAILURE);
                if (!authorized) {
                    if (authSubject.getProtocolVersion() >= 4) continue;
                    try {
                        session.write(ackMessage);
                        this.processDisconnect(session, clientID, true);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error((Object)("Failed to disconnect the client " + clientID), (Throwable)e);
                    }
                    return;
                }
            } else {
                log.error((Object)("Client " + clientID + " does not have permission to subscribe to topic : " + req.getTopicFilter()));
                ackMessage.addType(AbstractMessage.QOSType.FAILURE);
                continue;
            }
            AbstractMessage.QOSType qos = AbstractMessage.QOSType.values()[req.getQos()];
            Subscription newSubscription = new Subscription(clientID, req.getTopicFilter(), qos, cleanSession);
            this.subscribeSingleTopic(newSubscription);
            try {
                AndesMQTTBridge.getBridgeInstance().onTopicSubscription(req.getTopicFilter(), clientID, authSubject.getUsername(), qos, cleanSession);
            }
            catch (Exception e) {
                String message = "Error when registering the subscriber ";
                log.error((Object)("Error when registering the subscriber " + e.getMessage()), (Throwable)e);
                throw new RuntimeException("Error when registering the subscriber ", e);
            }
        }
        session.write(ackMessage);
    }

    private void subscribeSingleTopic(Subscription newSubscription) {
        this.subscriptions.add(newSubscription);
    }

    private void disruptorPublish(OutputMessagingEvent msgEvent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disruptorPublish publishing event on output " + msgEvent));
        }
        long sequence = this.m_ringBuffer.next();
        ValueEvent event = (ValueEvent)this.m_ringBuffer.get(sequence);
        event.setEvent(msgEvent);
        this.m_ringBuffer.publish(sequence);
    }

    public void onEvent(ValueEvent t, long l, boolean bln) throws Exception {
        MessagingEvent evt = t.getEvent();
        OutputMessagingEvent outEvent = (OutputMessagingEvent)evt;
        outEvent.getChannel().write(outEvent.getMessage());
    }

    @Override
    public void ack(AndesMessageMetadata metadata) {
        int qos = (Integer)metadata.getProperty("QOSLevel");
        String clientID = (String)metadata.getProperty("clientID");
        int messageID = (Integer)metadata.getProperty("MessageID");
        if (qos == AbstractMessage.QOSType.EXACTLY_ONCE.ordinal()) {
            this.sendPubComp(clientID, messageID);
        } else if (qos == AbstractMessage.QOSType.LEAST_ONE.ordinal()) {
            this.sendPubAck(clientID, messageID);
        }
    }

    @Override
    public void nack(AndesMessageMetadata metadata) {
    }
}

