/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dna.mqtt.moquette.messaging.spi.IMatchingCondition;
import org.dna.mqtt.moquette.messaging.spi.IStorageService;
import org.dna.mqtt.moquette.messaging.spi.impl.HawtDBStorageService;
import org.dna.mqtt.moquette.messaging.spi.impl.events.PublishEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.Subscription;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStorageService
implements IStorageService {
    private Map<String, Set<Subscription>> m_persistentSubscriptions = new HashMap<String, Set<Subscription>>();
    private Map<String, HawtDBStorageService.StoredMessage> m_retainedStore = new HashMap<String, HawtDBStorageService.StoredMessage>();
    private Map<String, List<PublishEvent>> m_persistentMessageStore = new HashMap<String, List<PublishEvent>>();
    private Map<String, PublishEvent> m_inflightStore = new HashMap<String, PublishEvent>();
    private Map<String, PublishEvent> m_qos2Store = new HashMap<String, PublishEvent>();
    private static final Logger LOG = LoggerFactory.getLogger(MemoryStorageService.class);

    @Override
    public void initStore() {
    }

    @Override
    public void storeRetained(String topic, ByteBuffer message, AbstractMessage.QOSType qos) {
        if (!message.hasRemaining()) {
            this.m_retainedStore.remove(topic);
        } else {
            byte[] raw = new byte[message.remaining()];
            message.get(raw);
            this.m_retainedStore.put(topic, new HawtDBStorageService.StoredMessage(raw, qos, topic));
        }
    }

    @Override
    public Collection<HawtDBStorageService.StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<HawtDBStorageService.StoredMessage> results = new ArrayList<HawtDBStorageService.StoredMessage>();
        for (Map.Entry<String, HawtDBStorageService.StoredMessage> entry : this.m_retainedStore.entrySet()) {
            HawtDBStorageService.StoredMessage storedMsg = entry.getValue();
            if (!condition.match(entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public void storePublishForFuture(PublishEvent evt) {
        LOG.debug("storePublishForFuture store evt {}", (Object)evt);
        String clientID = evt.getClientID();
        List<PublishEvent> storedEvents = !this.m_persistentMessageStore.containsKey(clientID) ? new ArrayList<PublishEvent>() : this.m_persistentMessageStore.get(clientID);
        storedEvents.add(evt);
        this.m_persistentMessageStore.put(clientID, storedEvents);
    }

    @Override
    public List<PublishEvent> retrivePersistedPublishes(String clientID) {
        return this.m_persistentMessageStore.get(clientID);
    }

    @Override
    public void cleanPersistedPublishMessage(String clientID, int messageID) {
        List<PublishEvent> events = this.m_persistentMessageStore.get(clientID);
        PublishEvent toRemoveEvt = null;
        for (PublishEvent evt : events) {
            if (evt.getMessageID() != messageID) continue;
            toRemoveEvt = evt;
        }
        events.remove(toRemoveEvt);
        this.m_persistentMessageStore.put(clientID, events);
    }

    @Override
    public void cleanPersistedPublishes(String clientID) {
        this.m_persistentMessageStore.remove(clientID);
    }

    @Override
    public void cleanInFlight(String msgID) {
        this.m_inflightStore.remove(msgID);
    }

    @Override
    public void addInFlight(PublishEvent evt, String publishKey) {
        this.m_inflightStore.put(publishKey, evt);
    }

    @Override
    public void addNewSubscription(Subscription newSubscription, String clientID) {
        Set<Subscription> subs;
        if (!this.m_persistentSubscriptions.containsKey(clientID)) {
            this.m_persistentSubscriptions.put(clientID, new HashSet());
        }
        if (!(subs = this.m_persistentSubscriptions.get(clientID)).contains(newSubscription)) {
            subs.add(newSubscription);
            this.m_persistentSubscriptions.put(clientID, subs);
        }
    }

    @Override
    public void removeAllSubscriptions(String clientID) {
        this.m_persistentSubscriptions.remove(clientID);
    }

    @Override
    public List<Subscription> retrieveAllSubscriptions() {
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        for (Map.Entry<String, Set<Subscription>> entry : this.m_persistentSubscriptions.entrySet()) {
            allSubscriptions.addAll((Collection<Subscription>)entry.getValue());
        }
        return allSubscriptions;
    }

    @Override
    public void close() {
    }

    @Override
    public void persistQoS2Message(String publishKey, PublishEvent evt) {
        LOG.debug("persistQoS2Message store pubKey {}, evt {}", (Object)publishKey, (Object)evt);
        this.m_qos2Store.put(publishKey, evt);
    }

    @Override
    public void removeQoS2Message(String publishKey) {
        this.m_qos2Store.remove(publishKey);
    }

    @Override
    public PublishEvent retrieveQoS2Message(String publishKey) {
        return this.m_qos2Store.get(publishKey);
    }
}

