/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.messaging.spi.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dna.mqtt.moquette.MQTTException;
import org.dna.mqtt.moquette.messaging.spi.IMatchingCondition;
import org.dna.mqtt.moquette.messaging.spi.IStorageService;
import org.dna.mqtt.moquette.messaging.spi.impl.events.PublishEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.storage.StoredPublishEvent;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.Subscription;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.moquette.server.Server;
import org.fusesource.hawtbuf.codec.StringCodec;
import org.fusesource.hawtdb.api.BTreeIndexFactory;
import org.fusesource.hawtdb.api.MultiIndexFactory;
import org.fusesource.hawtdb.api.PageFile;
import org.fusesource.hawtdb.api.PageFileFactory;
import org.fusesource.hawtdb.api.SortedIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtDBStorageService
implements IStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(HawtDBStorageService.class);
    private MultiIndexFactory m_multiIndexFactory;
    private PageFileFactory pageFactory;
    private SortedIndex<String, List<StoredPublishEvent>> m_persistentMessageStore;
    private SortedIndex<String, StoredMessage> m_retainedStore;
    private SortedIndex<String, StoredPublishEvent> m_inflightStore;
    private SortedIndex<String, StoredPublishEvent> m_qos2Store;
    private SortedIndex<String, Set<Subscription>> m_persistentSubscriptions;

    public HawtDBStorageService() {
        File tmpFile;
        String storeFile = Server.STORAGE_FILE_PATH;
        this.pageFactory = new PageFileFactory();
        try {
            tmpFile = new File(storeFile);
            tmpFile.createNewFile();
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
            throw new MQTTException("Can't create temp file for subscriptions storage [" + storeFile + "]", ex);
        }
        this.pageFactory.setFile(tmpFile);
        this.pageFactory.open();
        PageFile pageFile = this.pageFactory.getPageFile();
        this.m_multiIndexFactory = new MultiIndexFactory(pageFile);
    }

    @Override
    public void initStore() {
        this.initRetainedStore();
        this.initPersistentMessageStore();
        this.initInflightMessageStore();
        this.initPersistentSubscriptions();
        this.initPersistentQoS2MessageStore();
    }

    private void initRetainedStore() {
        BTreeIndexFactory indexFactory = new BTreeIndexFactory();
        indexFactory.setKeyCodec(StringCodec.INSTANCE);
        this.m_retainedStore = (SortedIndex)this.m_multiIndexFactory.openOrCreate("retained", indexFactory);
    }

    private void initPersistentMessageStore() {
        BTreeIndexFactory indexFactory = new BTreeIndexFactory();
        indexFactory.setKeyCodec(StringCodec.INSTANCE);
        this.m_persistentMessageStore = (SortedIndex)this.m_multiIndexFactory.openOrCreate("persistedMessages", indexFactory);
    }

    private void initPersistentSubscriptions() {
        BTreeIndexFactory indexFactory = new BTreeIndexFactory();
        indexFactory.setKeyCodec(StringCodec.INSTANCE);
        this.m_persistentSubscriptions = (SortedIndex)this.m_multiIndexFactory.openOrCreate("subscriptions", indexFactory);
    }

    private void initInflightMessageStore() {
        BTreeIndexFactory indexFactory = new BTreeIndexFactory();
        indexFactory.setKeyCodec(StringCodec.INSTANCE);
        this.m_inflightStore = (SortedIndex)this.m_multiIndexFactory.openOrCreate("inflight", indexFactory);
    }

    private void initPersistentQoS2MessageStore() {
        BTreeIndexFactory indexFactory = new BTreeIndexFactory();
        indexFactory.setKeyCodec(StringCodec.INSTANCE);
        this.m_qos2Store = (SortedIndex)this.m_multiIndexFactory.openOrCreate("qos2Store", indexFactory);
    }

    @Override
    public void storeRetained(String topic, ByteBuffer message, AbstractMessage.QOSType qos) {
    }

    @Override
    public Collection<StoredMessage> searchMatching(IMatchingCondition condition) {
        LOG.debug("searchMatching scanning all retained messages, presents are {}", (Object)this.m_retainedStore.size());
        ArrayList<StoredMessage> results = new ArrayList<StoredMessage>();
        for (Map.Entry<String, StoredMessage> entry : this.m_retainedStore) {
            StoredMessage storedMsg = entry.getValue();
            if (!condition.match(entry.getKey())) continue;
            results.add(storedMsg);
        }
        return results;
    }

    @Override
    public void storePublishForFuture(PublishEvent evt) {
        String clientID = evt.getClientID();
        List<StoredPublishEvent> storedEvents = !this.m_persistentMessageStore.containsKey(clientID) ? new ArrayList<StoredPublishEvent>() : (List)this.m_persistentMessageStore.get(clientID);
        storedEvents.add(this.convertToStored(evt));
        this.m_persistentMessageStore.put(clientID, storedEvents);
        LOG.debug("Stored published message for client <{}> on topic <{}>", (Object)clientID, (Object)evt.getTopic());
    }

    @Override
    public List<PublishEvent> retrivePersistedPublishes(String clientID) {
        List storedEvts = (List)this.m_persistentMessageStore.get(clientID);
        if (storedEvts == null) {
            return null;
        }
        ArrayList<PublishEvent> liveEvts = new ArrayList<PublishEvent>();
        for (StoredPublishEvent storedEvt : storedEvts) {
            liveEvts.add(this.convertFromStored(storedEvt));
        }
        return liveEvts;
    }

    @Override
    public void cleanPersistedPublishMessage(String clientID, int messageID) {
        List events = (List)this.m_persistentMessageStore.get(clientID);
        if (events == null) {
            return;
        }
        StoredPublishEvent toRemoveEvt = null;
        for (StoredPublishEvent evt : events) {
            if (evt.getMessageID() != messageID) continue;
            toRemoveEvt = evt;
        }
        events.remove(toRemoveEvt);
        this.m_persistentMessageStore.put(clientID, events);
    }

    @Override
    public void cleanPersistedPublishes(String clientID) {
        this.m_persistentMessageStore.remove(clientID);
    }

    @Override
    public void cleanInFlight(String msgID) {
        this.m_inflightStore.remove(msgID);
    }

    @Override
    public void addInFlight(PublishEvent evt, String publishKey) {
        StoredPublishEvent storedEvt = this.convertToStored(evt);
        this.m_inflightStore.put(publishKey, storedEvt);
    }

    @Override
    public void addNewSubscription(Subscription newSubscription, String clientID) {
        Set subs;
        LOG.debug("addNewSubscription invoked with subscription {} for client {}", (Object)newSubscription, (Object)clientID);
        if (!this.m_persistentSubscriptions.containsKey(clientID)) {
            LOG.debug("clientID {} is a newcome, creating it's subscriptions set", (Object)clientID);
            this.m_persistentSubscriptions.put(clientID, new HashSet());
        }
        if (!(subs = (Set)this.m_persistentSubscriptions.get(clientID)).contains(newSubscription)) {
            LOG.debug("updating clientID {} subscriptions set with new subscription", (Object)clientID);
            Subscription existingSubscription = null;
            for (Subscription scanSub : subs) {
                if (!newSubscription.getTopic().equals(scanSub.getTopic())) continue;
                existingSubscription = scanSub;
                break;
            }
            if (existingSubscription != null) {
                subs.remove(existingSubscription);
            }
            subs.add(newSubscription);
            this.m_persistentSubscriptions.put(clientID, subs);
            LOG.debug("clientID {} subscriptions set now is {}", (Object)clientID, (Object)subs);
        }
    }

    @Override
    public void removeAllSubscriptions(String clientID) {
        this.m_persistentSubscriptions.remove(clientID);
    }

    @Override
    public List<Subscription> retrieveAllSubscriptions() {
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        for (Map.Entry<String, Set<Subscription>> entry : this.m_persistentSubscriptions) {
            allSubscriptions.addAll((Collection<Subscription>)entry.getValue());
        }
        LOG.debug("retrieveAllSubscriptions returning subs {}", allSubscriptions);
        return allSubscriptions;
    }

    @Override
    public void close() {
        LOG.debug("closing disk storage");
        try {
            this.pageFactory.close();
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    @Override
    public void persistQoS2Message(String publishKey, PublishEvent evt) {
        LOG.debug("persistQoS2Message store pubKey {}, evt {}", (Object)publishKey, (Object)evt);
        this.m_qos2Store.put(publishKey, this.convertToStored(evt));
    }

    @Override
    public void removeQoS2Message(String publishKey) {
        this.m_qos2Store.remove(publishKey);
    }

    @Override
    public PublishEvent retrieveQoS2Message(String publishKey) {
        StoredPublishEvent storedEvt = (StoredPublishEvent)this.m_qos2Store.get(publishKey);
        return this.convertFromStored(storedEvt);
    }

    private StoredPublishEvent convertToStored(PublishEvent evt) {
        StoredPublishEvent storedEvt = new StoredPublishEvent(evt);
        return storedEvt;
    }

    private PublishEvent convertFromStored(StoredPublishEvent evt) {
        PublishEvent liveEvt = null;
        if (null != evt) {
            byte[] message = evt.getMessage();
            ByteBuffer bbmessage = ByteBuffer.wrap(message);
            liveEvt = new PublishEvent(evt.getTopic(), evt.getQos(), bbmessage, evt.isRetain(), evt.getClientID(), evt.getMessageID(), null);
        }
        return liveEvt;
    }

    public static class StoredMessage
    implements Serializable {
        AbstractMessage.QOSType m_qos;
        byte[] m_payload;
        String m_topic;

        StoredMessage(byte[] message, AbstractMessage.QOSType qos, String topic) {
            this.m_qos = qos;
            this.m_payload = message;
            this.m_topic = topic;
        }

        AbstractMessage.QOSType getQos() {
            return this.m_qos;
        }

        ByteBuffer getPayload() {
            return (ByteBuffer)ByteBuffer.allocate(this.m_payload.length).put(this.m_payload).flip();
        }

        String getTopic() {
            return this.m_topic;
        }
    }
}

