/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility;

import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.ordered.OrderedIterable;
import com.gs.collections.impl.utility.internal.RandomAccessListIterate;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedIterate {
    private OrderedIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <S, T> boolean corresponds(OrderedIterable<T> o1, OrderedIterable<S> o2, Predicate2<? super T, ? super S> predicate) {
        if (o1.size() != o2.size()) {
            return false;
        }
        if (o1 instanceof RandomAccess) {
            return RandomAccessListIterate.corresponds((List)((Object)o1), o2, predicate);
        }
        if (o2 instanceof RandomAccess) {
            List otherList = (List)((Object)o2);
            Iterator iterator = o1.iterator();
            for (int index = 0; index < otherList.size(); ++index) {
                if (predicate.accept(iterator.next(), otherList.get(index))) continue;
                return false;
            }
            return true;
        }
        Iterator iterator1 = o1.iterator();
        Iterator iterator2 = o2.iterator();
        while (iterator1.hasNext()) {
            if (predicate.accept(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }
}

