/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.tuple.primitive;

import com.gs.collections.api.tuple.primitive.FloatObjectPair;
import com.gs.collections.impl.block.factory.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatObjectPairImpl<T>
implements FloatObjectPair<T> {
    private static final long serialVersionUID = 1L;
    private final float one;
    private final T two;

    FloatObjectPairImpl(float newOne, T newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public float getOne() {
        return this.one;
    }

    @Override
    public T getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatObjectPair)) {
            return false;
        }
        FloatObjectPair that = (FloatObjectPair)o;
        return Float.compare(this.one, that.getOne()) == 0 && Comparators.nullSafeEquals(this.two, that.getTwo());
    }

    public int hashCode() {
        return 29 * Float.floatToIntBits(this.one) + (this.two == null ? 0 : this.two.hashCode());
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(FloatObjectPair<T> that) {
        int i = Float.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return ((Comparable)this.two).compareTo(that.getTwo());
    }
}

