/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.tuple.primitive;

import com.gs.collections.api.tuple.primitive.ByteFloatPair;

public class ByteFloatPairImpl
implements ByteFloatPair {
    private static final long serialVersionUID = 1L;
    private final byte one;
    private final float two;

    ByteFloatPairImpl(byte newOne, float newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public byte getOne() {
        return this.one;
    }

    public float getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteFloatPair)) {
            return false;
        }
        ByteFloatPair that = (ByteFloatPair)o;
        return this.one == that.getOne() && Float.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * this.one + Float.floatToIntBits(this.two);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public int compareTo(ByteFloatPair that) {
        int i = this.one - that.getOne();
        if (i != 0) {
            return i;
        }
        return Float.compare(this.two, that.getTwo());
    }
}

