/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.MutableShortStack;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedShortStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableShortStack
implements MutableShortStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortStack stack;

    UnmodifiableShortStack(MutableShortStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(short item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public short pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public ShortList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public short peek() {
        return this.stack.peek();
    }

    @Override
    public ShortList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public short peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(short value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.stack.shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableShortStack select(ShortPredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableShortStack reject(ShortPredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public long sum() {
        return this.stack.sum();
    }

    @Override
    public short max() {
        return this.stack.max();
    }

    @Override
    public short min() {
        return this.stack.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableShortList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public short[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public short[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableShortList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableShortSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableShortBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public MutableShortStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableShortStack asSynchronized() {
        return new SynchronizedShortStack(this);
    }

    @Override
    public ImmutableShortStack toImmutable() {
        return ShortStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

