/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;
import com.gs.collections.api.stack.primitive.MutableLongStack;
import com.gs.collections.impl.factory.primitive.LongStacks;
import com.gs.collections.impl.iterator.UnmodifiableLongIterator;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedLongStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableLongStack
implements MutableLongStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongStack stack;

    UnmodifiableLongStack(MutableLongStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(long item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public long pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public LongList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public long peek() {
        return this.stack.peek();
    }

    @Override
    public LongList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public long peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(long value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(long ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.stack.longIterator());
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableLongStack select(LongPredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableLongStack reject(LongPredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public long sum() {
        return this.stack.sum();
    }

    @Override
    public long max() {
        return this.stack.max();
    }

    @Override
    public long min() {
        return this.stack.min();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableLongList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public long[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public long[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableLongList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableLongSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableLongBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public MutableLongStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableLongStack asSynchronized() {
        return new SynchronizedLongStack(this);
    }

    @Override
    public ImmutableLongStack toImmutable() {
        return LongStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

