/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.api.stack.primitive.MutableIntStack;
import com.gs.collections.impl.factory.primitive.IntStacks;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedIntStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableIntStack
implements MutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntStack stack;

    UnmodifiableIntStack(MutableIntStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(int item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public int pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public IntList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public int peek() {
        return this.stack.peek();
    }

    @Override
    public IntList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public int peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(int value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.stack.intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableIntStack select(IntPredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableIntStack reject(IntPredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public long sum() {
        return this.stack.sum();
    }

    @Override
    public int max() {
        return this.stack.max();
    }

    @Override
    public int min() {
        return this.stack.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableIntList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public int[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public int[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public MutableIntStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    @Override
    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

