/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableFloatStack;
import com.gs.collections.api.stack.primitive.MutableFloatStack;
import com.gs.collections.impl.factory.primitive.FloatStacks;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedFloatStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableFloatStack
implements MutableFloatStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatStack stack;

    UnmodifiableFloatStack(MutableFloatStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(float item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public float pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public FloatList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public float peek() {
        return this.stack.peek();
    }

    @Override
    public FloatList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public float peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(float value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.stack.floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableFloatStack select(FloatPredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableFloatStack reject(FloatPredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public double sum() {
        return this.stack.sum();
    }

    @Override
    public float max() {
        return this.stack.max();
    }

    @Override
    public float min() {
        return this.stack.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public float[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public float[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableFloatList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableFloatSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public MutableFloatStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableFloatStack asSynchronized() {
        return new SynchronizedFloatStack(this);
    }

    @Override
    public ImmutableFloatStack toImmutable() {
        return FloatStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

