/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.api.stack.primitive.MutableDoubleStack;
import com.gs.collections.impl.factory.primitive.DoubleStacks;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedDoubleStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableDoubleStack
implements MutableDoubleStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleStack stack;

    UnmodifiableDoubleStack(MutableDoubleStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(double item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public double pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public DoubleList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public double peek() {
        return this.stack.peek();
    }

    @Override
    public DoubleList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public double peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(double value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(this.stack.doubleIterator());
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableDoubleStack select(DoublePredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableDoubleStack reject(DoublePredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public double sum() {
        return this.stack.sum();
    }

    @Override
    public double max() {
        return this.stack.max();
    }

    @Override
    public double min() {
        return this.stack.min();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableDoubleList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public double[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public double[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableDoubleList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableDoubleSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableDoubleBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public MutableDoubleStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableDoubleStack asSynchronized() {
        return new SynchronizedDoubleStack(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return DoubleStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

