/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.ByteList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableByteStack;
import com.gs.collections.api.stack.primitive.MutableByteStack;
import com.gs.collections.impl.factory.primitive.ByteStacks;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedByteStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableByteStack
implements MutableByteStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteStack stack;

    UnmodifiableByteStack(MutableByteStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(byte item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public byte pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public ByteList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public byte peek() {
        return this.stack.peek();
    }

    @Override
    public ByteList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public byte peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(byte value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(this.stack.byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(BytePredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableByteStack select(BytePredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableByteStack reject(BytePredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public long sum() {
        return this.stack.sum();
    }

    @Override
    public byte max() {
        return this.stack.max();
    }

    @Override
    public byte min() {
        return this.stack.min();
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableByteList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public byte[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public byte[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableByteList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableByteSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableByteBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public MutableByteStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableByteStack asSynchronized() {
        return new SynchronizedByteStack(this);
    }

    @Override
    public ImmutableByteStack toImmutable() {
        return ByteStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

