/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.BooleanList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableBooleanStack;
import com.gs.collections.api.stack.primitive.MutableBooleanStack;
import com.gs.collections.impl.factory.primitive.BooleanStacks;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedBooleanStack;
import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class UnmodifiableBooleanStack
implements MutableBooleanStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableBooleanStack stack;

    UnmodifiableBooleanStack(MutableBooleanStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(boolean item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public BooleanList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean peek() {
        return this.stack.peek();
    }

    @Override
    public BooleanList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public boolean peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(boolean value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.stack.booleanIterator());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableBooleanStack select(BooleanPredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableBooleanStack reject(BooleanPredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    @Override
    public boolean[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableBooleanList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableBooleanSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableBooleanBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    @Override
    public MutableBooleanStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableBooleanStack asSynchronized() {
        return new SynchronizedBooleanStack(this);
    }

    @Override
    public ImmutableBooleanStack toImmutable() {
        return BooleanStacks.immutable.withAllReversed(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }
}

