/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.MutableShortStack;
import com.gs.collections.api.stack.primitive.ShortStack;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedShortStack;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableShortStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class ShortArrayStack
implements MutableShortStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient ShortArrayList delegate;

    public ShortArrayStack() {
        this.delegate = new ShortArrayList();
    }

    private ShortArrayStack(int size) {
        this.delegate = new ShortArrayList(size);
    }

    private ShortArrayStack(short ... items) {
        this.delegate = new ShortArrayList(items);
    }

    public static ShortArrayStack newStackFromTopToBottom(short ... items) {
        ShortArrayStack stack = new ShortArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static ShortArrayStack newStackWith(short ... items) {
        return new ShortArrayStack(items);
    }

    public static ShortArrayStack newStack(ShortIterable items) {
        ShortArrayStack stack = new ShortArrayStack(items.size());
        stack.delegate = ShortArrayList.newList(items);
        return stack;
    }

    public static ShortArrayStack newStackFromTopToBottom(ShortIterable items) {
        ShortArrayStack stack = new ShortArrayStack(items.size());
        stack.delegate = ShortArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    public void push(short item) {
        this.delegate.add(item);
    }

    @Override
    public short pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    @Override
    public ShortList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ShortArrayList(0);
        }
        ShortArrayList subList = new ShortArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    @Override
    public MutableShortStack select(ShortPredicate predicate) {
        return ShortArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableShortStack reject(ShortPredicate predicate) {
        return ShortArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public short peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    @Override
    public ShortList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ShortArrayList(0);
        }
        ShortArrayList subList = new ShortArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public short peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.delegate.asReversed().shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.asReversed().injectInto(injectedValue, function);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public short max() {
        return this.delegate.max();
    }

    @Override
    public short min() {
        return this.delegate.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public short[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(short value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ShortStack)) {
            return false;
        }
        ShortStack stack = (ShortStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        LazyShortIterable iterable = this.delegate.asReversed();
        ShortIterator iterator = iterable.shortIterator();
        while (iterator.hasNext()) {
            short item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    @Override
    public MutableShortList toList() {
        return ShortArrayList.newList(this);
    }

    @Override
    public MutableShortList toSortedList() {
        return ShortArrayList.newList(this).sortThis();
    }

    @Override
    public MutableShortSet toSet() {
        return ShortHashSet.newSet(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortHashBag.newBag(this);
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public MutableShortStack asUnmodifiable() {
        return new UnmodifiableShortStack(this);
    }

    @Override
    public MutableShortStack asSynchronized() {
        return new SynchronizedShortStack(this);
    }

    @Override
    public ImmutableShortStack toImmutable() {
        return ShortStacks.immutable.withAll(this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        ShortIterator iterator = this.delegate.asReversed().shortIterator();
        while (iterator.hasNext()) {
            short each = iterator.next();
            out.writeShort(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        short[] array = new short[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readShort();
        }
        this.delegate = ShortArrayList.newListWith(array);
    }
}

