/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.stack.primitive.MutableIntStackFactory;
import com.gs.collections.api.stack.primitive.MutableIntStack;
import com.gs.collections.impl.stack.mutable.primitive.IntArrayStack;

public class MutableIntStackFactoryImpl
implements MutableIntStackFactory {
    public MutableIntStack empty() {
        return new IntArrayStack();
    }

    public MutableIntStack of() {
        return this.empty();
    }

    public MutableIntStack with() {
        return this.empty();
    }

    public MutableIntStack of(int ... items) {
        return this.with(items);
    }

    public MutableIntStack with(int ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return IntArrayStack.newStackWith(items);
    }

    public MutableIntStack ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public MutableIntStack withAll(IntIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return IntArrayStack.newStack(items);
    }

    public MutableIntStack ofAllReversed(IntIterable items) {
        return this.withAllReversed(items);
    }

    public MutableIntStack withAllReversed(IntIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return IntArrayStack.newStackFromTopToBottom(items);
    }
}

