/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.DoubleStack;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.api.stack.primitive.MutableDoubleStack;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.primitive.DoubleStacks;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedDoubleStack;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableDoubleStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class DoubleArrayStack
implements MutableDoubleStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient DoubleArrayList delegate;

    public DoubleArrayStack() {
        this.delegate = new DoubleArrayList();
    }

    private DoubleArrayStack(int size) {
        this.delegate = new DoubleArrayList(size);
    }

    private DoubleArrayStack(double ... items) {
        this.delegate = new DoubleArrayList(items);
    }

    public static DoubleArrayStack newStackFromTopToBottom(double ... items) {
        DoubleArrayStack stack = new DoubleArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static DoubleArrayStack newStackWith(double ... items) {
        return new DoubleArrayStack(items);
    }

    public static DoubleArrayStack newStack(DoubleIterable items) {
        DoubleArrayStack stack = new DoubleArrayStack(items.size());
        stack.delegate = DoubleArrayList.newList(items);
        return stack;
    }

    public static DoubleArrayStack newStackFromTopToBottom(DoubleIterable items) {
        DoubleArrayStack stack = new DoubleArrayStack(items.size());
        stack.delegate = DoubleArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    public void push(double item) {
        this.delegate.add(item);
    }

    @Override
    public double pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    @Override
    public DoubleList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        DoubleArrayList subList = new DoubleArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    @Override
    public MutableDoubleStack select(DoublePredicate predicate) {
        return DoubleArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableDoubleStack reject(DoublePredicate predicate) {
        return DoubleArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public double peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    @Override
    public DoubleList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        DoubleArrayList subList = new DoubleArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public double peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(this.delegate.asReversed().doubleIterator());
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public int count(DoublePredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.asReversed().injectInto(injectedValue, function);
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public double max() {
        return this.delegate.max();
    }

    @Override
    public double min() {
        return this.delegate.min();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public double[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(double value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Double.compare(this.peekAt(i), stack.peekAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        LazyDoubleIterable iterable = this.delegate.asReversed();
        DoubleIterator iterator = iterable.doubleIterator();
        while (iterator.hasNext()) {
            double item = iterator.next();
            hashCode = 31 * hashCode + (int)(Double.doubleToLongBits(item) ^ Double.doubleToLongBits(item) >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList(this).sortThis();
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public MutableDoubleStack asUnmodifiable() {
        return new UnmodifiableDoubleStack(this);
    }

    @Override
    public MutableDoubleStack asSynchronized() {
        return new SynchronizedDoubleStack(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return DoubleStacks.immutable.withAll(this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        DoubleIterator iterator = this.delegate.asReversed().doubleIterator();
        while (iterator.hasNext()) {
            double each = iterator.next();
            out.writeDouble(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        double[] array = new double[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readDouble();
        }
        this.delegate = DoubleArrayList.newListWith(array);
    }
}

