/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.CharStack;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.api.stack.primitive.MutableCharStack;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.primitive.CharStacks;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedCharStack;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableCharStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class CharArrayStack
implements MutableCharStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient CharArrayList delegate;

    public CharArrayStack() {
        this.delegate = new CharArrayList();
    }

    private CharArrayStack(int size) {
        this.delegate = new CharArrayList(size);
    }

    private CharArrayStack(char ... items) {
        this.delegate = new CharArrayList(items);
    }

    public static CharArrayStack newStackFromTopToBottom(char ... items) {
        CharArrayStack stack = new CharArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static CharArrayStack newStackWith(char ... items) {
        return new CharArrayStack(items);
    }

    public static CharArrayStack newStack(CharIterable items) {
        CharArrayStack stack = new CharArrayStack(items.size());
        stack.delegate = CharArrayList.newList(items);
        return stack;
    }

    public static CharArrayStack newStackFromTopToBottom(CharIterable items) {
        CharArrayStack stack = new CharArrayStack(items.size());
        stack.delegate = CharArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    public void push(char item) {
        this.delegate.add(item);
    }

    @Override
    public char pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    @Override
    public CharList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new CharArrayList(0);
        }
        CharArrayList subList = new CharArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    @Override
    public MutableCharStack select(CharPredicate predicate) {
        return CharArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableCharStack reject(CharPredicate predicate) {
        return CharArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public char peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    @Override
    public CharList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new CharArrayList(0);
        }
        CharArrayList subList = new CharArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public char peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.delegate.asReversed().charIterator());
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.asReversed().injectInto(injectedValue, function);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public char max() {
        return this.delegate.max();
    }

    @Override
    public char min() {
        return this.delegate.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public char[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(char value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof CharStack)) {
            return false;
        }
        CharStack stack = (CharStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        LazyCharIterable iterable = this.delegate.asReversed();
        CharIterator iterator = iterable.charIterator();
        while (iterator.hasNext()) {
            char item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newList(this);
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newList(this).sortThis();
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSet(this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBag(this);
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public MutableCharStack asUnmodifiable() {
        return new UnmodifiableCharStack(this);
    }

    @Override
    public MutableCharStack asSynchronized() {
        return new SynchronizedCharStack(this);
    }

    @Override
    public ImmutableCharStack toImmutable() {
        return CharStacks.immutable.withAll(this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        CharIterator iterator = this.delegate.asReversed().charIterator();
        while (iterator.hasNext()) {
            char each = iterator.next();
            out.writeChar(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        char[] array = new char[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readChar();
        }
        this.delegate = CharArrayList.newListWith(array);
    }
}

