/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable;

import com.gs.collections.api.factory.stack.MutableStackFactory;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class MutableStackFactoryImpl
implements MutableStackFactory {
    @Override
    public <T> MutableStack<T> empty() {
        return ArrayStack.newStack();
    }

    @Override
    public <T> MutableStack<T> of() {
        return this.empty();
    }

    @Override
    public <T> MutableStack<T> with() {
        return this.empty();
    }

    @Override
    public <T> MutableStack<T> of(T ... elements) {
        return this.with(elements);
    }

    @Override
    public <T> MutableStack<T> with(T ... elements) {
        return ArrayStack.newStackWith(elements);
    }

    @Override
    public <T> MutableStack<T> ofAll(Iterable<? extends T> elements) {
        return this.withAll(elements);
    }

    @Override
    public <T> MutableStack<T> withAll(Iterable<? extends T> elements) {
        return ArrayStack.newStack(elements);
    }

    @Override
    public <T> MutableStack<T> ofReversed(T ... elements) {
        return this.withReversed(elements);
    }

    @Override
    public <T> MutableStack<T> withReversed(T ... elements) {
        return ArrayStack.newStackFromTopToBottom(elements);
    }

    @Override
    public <T> MutableStack<T> ofAllReversed(Iterable<? extends T> items) {
        return this.withAllReversed(items);
    }

    @Override
    public <T> MutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ArrayStack.newStackFromTopToBottom(items);
    }
}

