/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.ShortStack;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.iterator.ImmutableEmptyShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortEmptyStack
implements ImmutableShortStack,
Serializable {
    static final ImmutableShortStack INSTANCE = new ImmutableShortEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableShortEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ShortIterator shortIterator() {
        return ImmutableEmptyShortIterator.INSTANCE;
    }

    @Override
    public void forEach(ShortProcedure procedure) {
    }

    @Override
    public void each(ShortProcedure procedure) {
    }

    @Override
    public int count(ShortPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return true;
    }

    @Override
    public short peek() {
        throw new EmptyStackException();
    }

    @Override
    public ShortList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new ShortArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public short peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableShortStack select(ShortPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableShortStack reject(ShortPredicate predicate) {
        return this;
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public short max() {
        throw new NoSuchElementException();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return defaultValue;
    }

    @Override
    public short min() {
        throw new NoSuchElementException();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public short[] toSortedArray() {
        return new short[0];
    }

    @Override
    public MutableShortList toSortedList() {
        return new ShortArrayList();
    }

    @Override
    public short[] toArray() {
        return new short[0];
    }

    @Override
    public boolean contains(short value) {
        return false;
    }

    @Override
    public boolean containsAll(short ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableShortList toList() {
        return new ShortArrayList();
    }

    @Override
    public MutableShortSet toSet() {
        return new ShortHashSet();
    }

    @Override
    public MutableShortBag toBag() {
        return new ShortHashBag();
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public ImmutableShortStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableShortStack push(short element) {
        return ShortStacks.immutable.with(element);
    }

    @Override
    public ImmutableShortStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableShortStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ShortStack)) {
            return false;
        }
        ShortStack stack = (ShortStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

