/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;
import com.gs.collections.api.stack.primitive.ShortStack;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortProcedure;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.ShortStacks;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortArrayStack
implements ImmutableShortStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ShortArrayList delegate;

    private ImmutableShortArrayStack(short[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new ShortArrayList(newElements);
    }

    private ImmutableShortArrayStack(ShortArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use ShortStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableShortArrayStack newStack(ShortIterable iterable) {
        return new ImmutableShortArrayStack(iterable.toArray());
    }

    public static ImmutableShortArrayStack newStackWith(short ... elements) {
        short[] newArray = new short[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableShortArrayStack(newArray);
    }

    public static ImmutableShortArrayStack newStackFromTopToBottom(short ... items) {
        return new ImmutableShortArrayStack(ShortArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableShortArrayStack newStackFromTopToBottom(ShortIterable items) {
        return new ImmutableShortArrayStack(ShortArrayList.newList(items).reverseThis());
    }

    @Override
    public ImmutableShortStack push(short item) {
        ShortArrayList newDelegate = ShortArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableShortArrayStack(newDelegate);
    }

    @Override
    public ImmutableShortStack pop() {
        ShortArrayList newDelegate = ShortArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return ShortStacks.immutable.with(newDelegate.toArray());
    }

    @Override
    public ImmutableShortStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        ShortArrayList newDelegate = ShortArrayList.newList(this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return ShortStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public short peek() {
        return this.delegate.getLast();
    }

    @Override
    public ShortList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new ShortArrayList();
        }
        ShortArrayList subList = new ShortArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public short peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.delegate.asReversed().shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public ImmutableShortStack select(ShortPredicate predicate) {
        return ShortStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    @Override
    public ImmutableShortStack reject(ShortPredicate predicate) {
        return ShortStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableStack<V> collect(ShortToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed(this.delegate.asReversed().collect(function));
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public short max() {
        return this.delegate.max();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.max();
    }

    @Override
    public short min() {
        return this.delegate.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableShortList toSortedList() {
        return ShortArrayList.newList(this).sortThis();
    }

    @Override
    public short[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(short value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public MutableShortList toList() {
        return ShortArrayList.newList(this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortHashSet.newSet(this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortHashBag.newBag(this);
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public ImmutableShortStack toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof ShortStack)) {
            return false;
        }
        ShortStack stack = (ShortStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        LazyShortIterable iterable = this.delegate.asReversed();
        ShortIterator iterator = iterable.shortIterator();
        while (iterator.hasNext()) {
            short item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableShortStackSerializationProxy(this);
    }

    private static class ImmutableShortStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortStack stack;

        public ImmutableShortStackSerializationProxy() {
        }

        protected ImmutableShortStackSerializationProxy(ShortStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach(new CheckedShortProcedure(){

                    public void safeValue(short item) throws IOException {
                        out.writeShort(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ShortArrayList deserializedDelegate = new ShortArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readShort());
            }
            this.stack = ImmutableShortArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

