/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.DoubleStack;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.DoubleStacks;
import com.gs.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleEmptyStack
implements ImmutableDoubleStack,
Serializable {
    static final ImmutableDoubleStack INSTANCE = new ImmutableDoubleEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
    }

    @Override
    public void each(DoubleProcedure procedure) {
    }

    @Override
    public int count(DoublePredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    @Override
    public double peek() {
        throw new EmptyStackException();
    }

    @Override
    public DoubleList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public double peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return this;
    }

    @Override
    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return this;
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public double sum() {
        return 0.0;
    }

    @Override
    public double max() {
        throw new NoSuchElementException();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double min() {
        throw new NoSuchElementException();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public double[] toSortedArray() {
        return new double[0];
    }

    @Override
    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    @Override
    public double[] toArray() {
        return new double[0];
    }

    @Override
    public boolean contains(double value) {
        return false;
    }

    @Override
    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    @Override
    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    @Override
    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableDoubleStack push(double element) {
        return DoubleStacks.immutable.with(element);
    }

    @Override
    public ImmutableDoubleStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableDoubleStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

