/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.CharStack;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.CharStacks;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharEmptyStack
implements ImmutableCharStack,
Serializable {
    static final ImmutableCharStack INSTANCE = new ImmutableCharEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableCharEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public CharIterator charIterator() {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    @Override
    public void forEach(CharProcedure procedure) {
    }

    @Override
    public void each(CharProcedure procedure) {
    }

    @Override
    public int count(CharPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public char peek() {
        throw new EmptyStackException();
    }

    @Override
    public CharList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new CharArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public char peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableCharStack select(CharPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableCharStack reject(CharPredicate predicate) {
        return this;
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public char max() {
        throw new NoSuchElementException();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public char min() {
        throw new NoSuchElementException();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public char[] toSortedArray() {
        return new char[0];
    }

    @Override
    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    @Override
    public char[] toArray() {
        return new char[0];
    }

    @Override
    public boolean contains(char value) {
        return false;
    }

    @Override
    public boolean containsAll(char ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableCharList toList() {
        return new CharArrayList();
    }

    @Override
    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    @Override
    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public ImmutableCharStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableCharStack push(char element) {
        return CharStacks.immutable.with(element);
    }

    @Override
    public ImmutableCharStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableCharStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof CharStack)) {
            return false;
        }
        CharStack stack = (CharStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

