/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.CharStack;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedCharProcedure;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.CharStacks;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharArrayStack
implements ImmutableCharStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CharArrayList delegate;

    private ImmutableCharArrayStack(char[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new CharArrayList(newElements);
    }

    private ImmutableCharArrayStack(CharArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use CharStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableCharArrayStack newStack(CharIterable iterable) {
        return new ImmutableCharArrayStack(iterable.toArray());
    }

    public static ImmutableCharArrayStack newStackWith(char ... elements) {
        char[] newArray = new char[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableCharArrayStack(newArray);
    }

    public static ImmutableCharArrayStack newStackFromTopToBottom(char ... items) {
        return new ImmutableCharArrayStack(CharArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableCharArrayStack newStackFromTopToBottom(CharIterable items) {
        return new ImmutableCharArrayStack(CharArrayList.newList(items).reverseThis());
    }

    @Override
    public ImmutableCharStack push(char item) {
        CharArrayList newDelegate = CharArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableCharArrayStack(newDelegate);
    }

    @Override
    public ImmutableCharStack pop() {
        CharArrayList newDelegate = CharArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return CharStacks.immutable.with(newDelegate.toArray());
    }

    @Override
    public ImmutableCharStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        CharArrayList newDelegate = CharArrayList.newList(this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return CharStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public char peek() {
        return this.delegate.getLast();
    }

    @Override
    public CharList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new CharArrayList();
        }
        CharArrayList subList = new CharArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public char peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.delegate.asReversed().charIterator());
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public ImmutableCharStack select(CharPredicate predicate) {
        return CharStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    @Override
    public ImmutableCharStack reject(CharPredicate predicate) {
        return CharStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed(this.delegate.asReversed().collect(function));
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public char max() {
        return this.delegate.max();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.max();
    }

    @Override
    public char min() {
        return this.delegate.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newList(this).sortThis();
    }

    @Override
    public char[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(char value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newList(this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSet(this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBag(this);
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public ImmutableCharStack toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof CharStack)) {
            return false;
        }
        CharStack stack = (CharStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        LazyCharIterable iterable = this.delegate.asReversed();
        CharIterator iterator = iterable.charIterator();
        while (iterator.hasNext()) {
            char item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableCharStackSerializationProxy(this);
    }

    private static class ImmutableCharStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharStack stack;

        public ImmutableCharStackSerializationProxy() {
        }

        protected ImmutableCharStackSerializationProxy(CharStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach(new CheckedCharProcedure(){

                    public void safeValue(char item) throws IOException {
                        out.writeChar(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharArrayList deserializedDelegate = new CharArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readChar());
            }
            this.stack = ImmutableCharArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

