/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.strategy.immutable;

import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure;
import com.gs.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableSetWithHashingStrategySerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSet<T> set;
    private HashingStrategy<? super T> hashingStrategy;

    public ImmutableSetWithHashingStrategySerializationProxy() {
    }

    ImmutableSetWithHashingStrategySerializationProxy(ImmutableSet<T> set, HashingStrategy<? super T> hashingStrategy) {
        this.set = set;
        this.hashingStrategy = hashingStrategy;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedProcedure<T>(){

                @Override
                public void safeValue(T value) throws IOException {
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HashingStrategy strategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        UnifiedSetWithHashingStrategy deserializedSet = UnifiedSetWithHashingStrategy.newSet(strategy);
        for (int i = 0; i < size; ++i) {
            deserializedSet.put(in.readObject());
        }
        this.set = deserializedSet.toImmutable();
    }

    protected Object readResolve() {
        return this.set;
    }
}

