/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.sorted.mutable;

import com.gs.collections.api.factory.set.sorted.MutableSortedSetFactory;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import java.util.Comparator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class MutableSortedSetFactoryImpl
implements MutableSortedSetFactory {
    @Override
    public <T> MutableSortedSet<T> empty() {
        return TreeSortedSet.newSet();
    }

    @Override
    public <T> MutableSortedSet<T> of() {
        return this.empty();
    }

    @Override
    public <T> MutableSortedSet<T> with() {
        return this.empty();
    }

    @Override
    public <T> MutableSortedSet<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> MutableSortedSet<T> with(T ... items) {
        return TreeSortedSet.newSetWith(items);
    }

    @Override
    public <T> MutableSortedSet<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> MutableSortedSet<T> withAll(Iterable<? extends T> items) {
        return TreeSortedSet.newSet(items);
    }

    @Override
    public <T> MutableSortedSet<T> of(Comparator<? super T> comparator) {
        return this.with(comparator);
    }

    @Override
    public <T> MutableSortedSet<T> with(Comparator<? super T> comparator) {
        return TreeSortedSet.newSet(comparator);
    }

    @Override
    public <T> MutableSortedSet<T> of(Comparator<? super T> comparator, T ... items) {
        return this.with(comparator, items);
    }

    @Override
    public <T> MutableSortedSet<T> with(Comparator<? super T> comparator, T ... items) {
        return TreeSortedSet.newSetWith(comparator, items);
    }

    @Override
    public <T> MutableSortedSet<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        return this.withAll(comparator, items);
    }

    @Override
    public <T> MutableSortedSet<T> withAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        return TreeSortedSet.newSet(comparator, items);
    }
}

