/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedShortCollection;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedShortSet
extends AbstractSynchronizedShortCollection
implements MutableShortSet {
    private static final long serialVersionUID = 1L;

    SynchronizedShortSet(MutableShortSet set) {
        super(set);
    }

    SynchronizedShortSet(MutableShortSet set, Object newLock) {
        super(set, newLock);
    }

    public static SynchronizedShortSet of(MutableShortSet set) {
        return new SynchronizedShortSet(set);
    }

    public static SynchronizedShortSet of(MutableShortSet set, Object lock) {
        return new SynchronizedShortSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableShortSet getMutableShortSet() {
        return (MutableShortSet)this.getShortCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet without(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet with(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet withAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet withoutAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortSet select(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortSet reject(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyShortIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyShortIterableAdapter(this);
        }
    }

    @Override
    public MutableShortSet asUnmodifiable() {
        return new UnmodifiableShortSet(this);
    }

    @Override
    public MutableShortSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShortSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableShortSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().toImmutable();
        }
    }
}

