/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedCharCollection;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedCharSet
extends AbstractSynchronizedCharCollection
implements MutableCharSet {
    private static final long serialVersionUID = 1L;

    SynchronizedCharSet(MutableCharSet set) {
        super(set);
    }

    SynchronizedCharSet(MutableCharSet set, Object newLock) {
        super(set, newLock);
    }

    public static SynchronizedCharSet of(MutableCharSet set) {
        return new SynchronizedCharSet(set);
    }

    public static SynchronizedCharSet of(MutableCharSet set, Object lock) {
        return new SynchronizedCharSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableCharSet getMutableCharSet() {
        return (MutableCharSet)this.getCharCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet without(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet with(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet withAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet withoutAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet select(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet reject(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyCharIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyCharIterableAdapter(this);
        }
    }

    @Override
    public MutableCharSet asUnmodifiable() {
        return new UnmodifiableCharSet(this);
    }

    @Override
    public MutableCharSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCharSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().toImmutable();
        }
    }
}

