/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.multimap.set.MutableSetMultimap;
import com.gs.collections.api.partition.set.PartitionMutableSet;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.api.set.SetIterable;
import com.gs.collections.api.set.UnsortedSetIterable;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import com.gs.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.lazy.parallel.set.SynchronizedParallelUnsortedSetIterable;
import com.gs.collections.impl.set.mutable.SetAdapter;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SynchronizedMutableSet<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableSet<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableSet(MutableSet<T> set) {
        super(set);
    }

    SynchronizedMutableSet(MutableSet<T> set, Object newLock) {
        super(set, newLock);
    }

    public static <E, S extends Set<E>> SynchronizedMutableSet<E> of(S set) {
        return new SynchronizedMutableSet(SetAdapter.adapt(set));
    }

    public static <E, S extends Set<E>> SynchronizedMutableSet<E> of(S set, Object lock) {
        return new SynchronizedMutableSet(SetAdapter.adapt(set), lock);
    }

    @GuardedBy(value="getLock()")
    private MutableSet<T> getMutableSet() {
        return (MutableSet)this.getDelegate();
    }

    @Override
    public MutableSet<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getMutableSet().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy<T>(this.getMutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> tap(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.forEach(procedure);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> select(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> reject(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().unionInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().intersectInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().differenceInto(subtrahendSet, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().symmetricDifferenceInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().isSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().isProperSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().cartesianProduct(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> union(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().union(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().intersect(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().difference(subtrahendSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().symmetricDifference(setB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableSet().powerSet();
        }
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new SynchronizedParallelUnsortedSetIterable(this.getMutableSet().asParallel(executorService, batchSize), this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableMutableSet.of(this);
        }
    }

    @Override
    public MutableSet<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<T> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return Sets.immutable.withAll(this.getMutableSet());
        }
    }
}

