/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.ImmutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import com.gs.collections.impl.set.immutable.primitive.ImmutableTrueFalseSet;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableTrueSet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableTrueSet();

    private ImmutableTrueSet() {
    }

    @Override
    public ImmutableBooleanSet newWith(boolean element) {
        return element ? this : ImmutableTrueFalseSet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet newWithout(boolean element) {
        return element ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableBooleanSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    @Override
    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        return elements.contains(true) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new TrueIterator();
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        procedure.value(true);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, true);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return predicate.accept(true) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(true);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(true);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(true);
    }

    @Override
    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        return predicate.accept(true) ? this : ImmutableBooleanEmptySet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        return predicate.accept(true) ? ImmutableBooleanEmptySet.INSTANCE : this;
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(true) || ifNone;
    }

    @Override
    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(true));
    }

    @Override
    public boolean[] toArray() {
        return new boolean[]{true};
    }

    @Override
    public boolean contains(boolean value) {
        return value;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean item : source) {
            if (item) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public BooleanSet freeze() {
        return this;
    }

    @Override
    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return !other.contains(false) && other.contains(true);
    }

    @Override
    public int hashCode() {
        return 1231;
    }

    @Override
    public String toString() {
        return "[true]";
    }

    @Override
    public String makeString() {
        return "true";
    }

    @Override
    public String makeString(String separator) {
        return "true";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + "true" + end;
    }

    @Override
    public void appendString(Appendable appendable) {
        try {
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        try {
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("true");
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newList(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag(this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy(this);
    }

    private static final class TrueIterator
    implements BooleanIterator {
        private int currentIndex;

        private TrueIterator() {
        }

        public boolean next() {
            if (this.currentIndex == 0) {
                ++this.currentIndex;
                return true;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.currentIndex == 0;
        }
    }
}

