/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortProcedure;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableShortSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ShortSet set;

    public ImmutableShortSetSerializationProxy() {
    }

    public ImmutableShortSetSerializationProxy(ShortSet set) {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedShortProcedure(){

                public void safeValue(short item) throws Exception {
                    out.writeShort(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        ShortHashSet deserializedSet = new ShortHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readShort());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

