/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableLongSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private LongSet set;

    public ImmutableLongSetSerializationProxy() {
    }

    public ImmutableLongSetSerializationProxy(LongSet set) {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedLongProcedure(){

                public void safeValue(long item) throws Exception {
                    out.writeLong(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        LongHashSet deserializedSet = new LongHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readLong());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

