/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.iterator.ImmutableEmptyLongIterator;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableLongSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableLongEmptySet
implements ImmutableLongSet,
Serializable {
    static final ImmutableLongSet INSTANCE = new ImmutableLongEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableLongEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ImmutableLongSet newWith(long element) {
        return new ImmutableLongSingletonSet(element);
    }

    @Override
    public ImmutableLongSet newWithout(long element) {
        return this;
    }

    @Override
    public ImmutableLongSet newWithAll(LongIterable elements) {
        return LongSets.immutable.withAll(elements);
    }

    @Override
    public ImmutableLongSet newWithoutAll(LongIterable elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public boolean contains(long value) {
        return false;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return source.isEmpty();
    }

    @Override
    public boolean containsAll(long ... elements) {
        return elements.length == 0;
    }

    @Override
    public void forEach(LongProcedure procedure) {
    }

    @Override
    public void each(LongProcedure procedure) {
    }

    @Override
    public ImmutableLongSet select(LongPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableLongSet reject(LongPredicate predicate) {
        return this;
    }

    @Override
    public <V> ImmutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public MutableLongList toList() {
        return new LongArrayList();
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return ifNone;
    }

    @Override
    public int count(LongPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return false;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public long min() {
        throw new NoSuchElementException();
    }

    @Override
    public long max() {
        throw new NoSuchElementException();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return defaultValue;
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public long[] toSortedArray() {
        return new long[0];
    }

    @Override
    public MutableLongList toSortedList() {
        return new LongArrayList();
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return true;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet set = (LongSet)obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public MutableLongSet toSet() {
        return new LongHashSet();
    }

    @Override
    public MutableLongBag toBag() {
        return new LongHashBag();
    }

    @Override
    public LongSet freeze() {
        return this;
    }

    @Override
    public ImmutableLongSet toImmutable() {
        return this;
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public long[] toArray() {
        return new long[0];
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LongIterator longIterator() {
        return ImmutableEmptyLongIterator.INSTANCE;
    }
}

