/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.iterator.ImmutableEmptyIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableIntSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntEmptySet
implements ImmutableIntSet,
Serializable {
    static final ImmutableIntSet INSTANCE = new ImmutableIntEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableIntEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ImmutableIntSet newWith(int element) {
        return new ImmutableIntSingletonSet(element);
    }

    @Override
    public ImmutableIntSet newWithout(int element) {
        return this;
    }

    @Override
    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntSets.immutable.withAll(elements);
    }

    @Override
    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public boolean contains(int value) {
        return false;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    @Override
    public boolean containsAll(int ... elements) {
        return elements.length == 0;
    }

    @Override
    public void forEach(IntProcedure procedure) {
    }

    @Override
    public void each(IntProcedure procedure) {
    }

    @Override
    public ImmutableIntSet select(IntPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableIntSet reject(IntPredicate predicate) {
        return this;
    }

    @Override
    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public MutableIntList toList() {
        return new IntArrayList();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    @Override
    public int count(IntPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public int min() {
        throw new NoSuchElementException();
    }

    @Override
    public int max() {
        throw new NoSuchElementException();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public int[] toSortedArray() {
        return new int[0];
    }

    @Override
    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet set = (IntSet)obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    @Override
    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    @Override
    public IntSet freeze() {
        return this;
    }

    @Override
    public ImmutableIntSet toImmutable() {
        return this;
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public int[] toArray() {
        return new int[0];
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }
}

