/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatSingletonSet
implements ImmutableFloatSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element;

    ImmutableFloatSingletonSet(float element) {
        this.element = element;
    }

    @Override
    public ImmutableFloatSet newWith(float element) {
        return FloatSets.immutable.with(this.element, element);
    }

    @Override
    public ImmutableFloatSet newWithout(float element) {
        return Float.compare(this.element, element) == 0 ? FloatSets.immutable.with() : this;
    }

    @Override
    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatHashSet.newSet(elements).with(this.element).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element) ? FloatSets.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean contains(float value) {
        return Float.compare(this.element, value) == 0;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        procedure.value(this.element);
    }

    @Override
    public ImmutableFloatSet select(FloatPredicate predicate) {
        return predicate.accept(this.element) ? FloatHashSet.newSetWith(this.element).toImmutable() : new FloatHashSet().toImmutable();
    }

    @Override
    public ImmutableFloatSet reject(FloatPredicate predicate) {
        return predicate.accept(this.element) ? new FloatHashSet().toImmutable() : FloatHashSet.newSetWith(this.element).toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(float item) {
        return Float.compare(this.element, item) == 0 ? 1 : 0;
    }

    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure) {
        floatIntProcedure.value(this.element, 1);
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    @Override
    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element);
    }

    @Override
    public double sum() {
        return this.element;
    }

    @Override
    public float min() {
        return this.element;
    }

    @Override
    public float max() {
        return this.element;
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.element;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.element;
    }

    @Override
    public double average() {
        return this.element;
    }

    @Override
    public double median() {
        return this.element;
    }

    @Override
    public float[] toSortedArray() {
        return new float[]{this.element};
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatSet)) {
            return false;
        }
        FloatSet set = (FloatSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.element);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element);
    }

    @Override
    public FloatSet freeze() {
        return this;
    }

    @Override
    public ImmutableFloatSet toImmutable() {
        return this;
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public float[] toArray() {
        return new float[]{this.element};
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(FloatHashSet.newSetWith(this.element).floatIterator());
    }
}

