/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableDoubleSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleEmptySet
implements ImmutableDoubleSet,
Serializable {
    static final ImmutableDoubleSet INSTANCE = new ImmutableDoubleEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ImmutableDoubleSet newWith(double element) {
        return new ImmutableDoubleSingletonSet(element);
    }

    @Override
    public ImmutableDoubleSet newWithout(double element) {
        return this;
    }

    @Override
    public ImmutableDoubleSet newWithAll(DoubleIterable elements) {
        return DoubleSets.immutable.withAll(elements);
    }

    @Override
    public ImmutableDoubleSet newWithoutAll(DoubleIterable elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public boolean contains(double value) {
        return false;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    @Override
    public boolean containsAll(double ... elements) {
        return elements.length == 0;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
    }

    @Override
    public void each(DoubleProcedure procedure) {
    }

    @Override
    public ImmutableDoubleSet select(DoublePredicate predicate) {
        return this;
    }

    @Override
    public ImmutableDoubleSet reject(DoublePredicate predicate) {
        return this;
    }

    @Override
    public <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    @Override
    public int count(DoublePredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    @Override
    public double sum() {
        return 0.0;
    }

    @Override
    public double min() {
        throw new NoSuchElementException();
    }

    @Override
    public double max() {
        throw new NoSuchElementException();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public double[] toSortedArray() {
        return new double[0];
    }

    @Override
    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleSet)) {
            return false;
        }
        DoubleSet set = (DoubleSet)obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    @Override
    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    @Override
    public DoubleSet freeze() {
        return this;
    }

    @Override
    public ImmutableDoubleSet toImmutable() {
        return this;
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public double[] toArray() {
        return new double[0];
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }
}

