/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedCharProcedure;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableCharSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private CharSet set;

    public ImmutableCharSetSerializationProxy() {
    }

    public ImmutableCharSetSerializationProxy(CharSet set) {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedCharProcedure(){

                public void safeValue(char item) throws Exception {
                    out.writeChar(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        CharHashSet deserializedSet = new CharHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readChar());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

