/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableCharSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharEmptySet
implements ImmutableCharSet,
Serializable {
    static final ImmutableCharSet INSTANCE = new ImmutableCharEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableCharEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ImmutableCharSet newWith(char element) {
        return new ImmutableCharSingletonSet(element);
    }

    @Override
    public ImmutableCharSet newWithout(char element) {
        return this;
    }

    @Override
    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharSets.immutable.withAll(elements);
    }

    @Override
    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public boolean contains(char value) {
        return false;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    @Override
    public boolean containsAll(char ... elements) {
        return elements.length == 0;
    }

    @Override
    public void forEach(CharProcedure procedure) {
    }

    @Override
    public void each(CharProcedure procedure) {
    }

    @Override
    public ImmutableCharSet select(CharPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableCharSet reject(CharPredicate predicate) {
        return this;
    }

    @Override
    public <V> ImmutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public MutableCharList toList() {
        return new CharArrayList();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    @Override
    public int count(CharPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public char min() {
        throw new NoSuchElementException();
    }

    @Override
    public char max() {
        throw new NoSuchElementException();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public char[] toSortedArray() {
        return new char[0];
    }

    @Override
    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet set = (CharSet)obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    @Override
    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    @Override
    public CharSet freeze() {
        return this;
    }

    @Override
    public ImmutableCharSet toImmutable() {
        return this;
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public char[] toArray() {
        return new char[0];
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharIterator charIterator() {
        return ImmutableEmptyCharIterator.INSTANCE;
    }
}

