/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedBooleanProcedure;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ImmutableBooleanSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private BooleanSet set;

    public ImmutableBooleanSetSerializationProxy() {
    }

    public ImmutableBooleanSetSerializationProxy(BooleanSet set) {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedBooleanProcedure(){

                public void safeValue(boolean item) throws Exception {
                    out.writeBoolean(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        BooleanHashSet deserializedSet = new BooleanHashSet();
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readBoolean());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

